% Skript RLC_dc_dc1.m in dem ein DC-DC-Wandler mit
% RLC-Reihenschaltung untersucht wird

clear

% ------- Parameter des Systems
Rs = 50;     
L = 0.2e-3;   C = 20e-6;
RL = 0.01;

iL0 = 0;   uc0 = 0;
Ug = 10;

f = 20e3;    T = 1/f
% ------ Numerische Integration
dt = T/1000;      Tfinal = 40*T;
t = 0:dt:Tfinal;
nt = length(t);

% ------ Erzeugung der Pulse
schwelle = 0.6;   % zwischen 0 und 1
ug = Ug*(sign((f*t - floor(f*t))-schwelle)+1)/2;

iL = zeros(1,nt);  uc = zeros(1,nt);
iL(1) = iL0;       uc(1) = uc0;

for k = 1:nt-1
    iL(k+1) = iL(k) + dt*(-RL*iL(k) - uc(k) + ug(k))/L;
    if iL(k+1) < 0, 
        iL(k+1) = 0;  % wegen der Diode
    end;
    uc(k+1) = uc(k) + dt*(iL(k)-uc(k)/Rs)/C;
end;

% ------- Spannung des Induktors
uL = -iL*RL + ug -uc;

figure(1);
nd = 1:fix(nt/2);

subplot(211), plot(t(nd), iL(nd));
title(['Strom   iL  ( Rs = ', num2str(Rs),' Ohm ;',...
     '   T1 / (T1 + T2) = ',num2str(1-schwelle),' )']);
xlabel('Zeit in s');   grid on;
La = axis;    axis([La(1:2), -0.2*Ug/Rs, La(4)])

subplot(212), plot(t(nd), ug(nd), t(nd), uc(nd), t(nd), uL(nd));
title('Spannung ug, uc und uL');
xlabel('Zeit in s');   grid on;
La = axis;    axis([La(1:3), Ug+1])

% Stationaerer Zustand 
figure(2);
nd = fix(2*nt/3):nt;

subplot(211), plot(t(nd), iL(nd));
title(['Strom   iL  ( Rs = ', num2str(Rs),' Ohm ;',...
     '   T1 / (T1 + T2) = ',num2str(1-schwelle),' )']);
xlabel('Zeit in s');   grid on;
La = axis;    axis([t(fix(2*nt/3)),La(2), -0.2*Ug/Rs, La(4)])

subplot(212), plot(t(nd), ug(nd), t(nd), uc(nd), t(nd), uL(nd));
title('Spannung ug, uc und uL');
xlabel('Zeit in s');   grid on;
La = axis;    axis([t(fix(2*nt/3)), La(2:3), Ug+1])


