% Skript RC-zwei_quellen1.m in dem eine RC-Schaltung
% mit zwei Quellen untersucht wird

clear

% ------ Parameter der Schaltung
R1 = 50;    R2 = 200;
C = 0.0002;
R12 = R1*R2/(R1 + R2);
Uc0 = -5;

ug1_ampl = 10;
f = 100;    omega = 2*pi*f;
T = 1/f;
phi = pi/3;

Ug2 = 5;

% Loesung
tau = R12*C;     % Zeitkonstante
uc1_ampl = ug1_ampl*R2/((R1+R2)*sqrt(1 + (omega*C*R12)^2));
phi_c = atan2(-omega*R12*C,1);

% ------ Zeitverhalten
Tfinal = 20*T;    % Darstellungszeit
dt = T/200;      % Zeitschritt
t = 0:dt:Tfinal;
nt = length(t);

C_h = Uc0 - uc1_ampl*cos(phi + phi_c) - Ug2*R1/(R1 + R2);

uc = C_h*exp(-t/tau) + uc1_ampl*cos(omega*t + phi + phi_c) + ...
    Ug2*R1/(R1 + R2);
ug = ug1_ampl* cos(omega*t + phi)*R2/(R1 + R2) + ...
    Ug2*ones(1,nt)*R1/(R1 + R2);  % Ersatzeingangsspannung



%#####################
figure(1);
plot(t, ug, t, uc);
title(['Ersatzspannung ug,  und Spannung  uc (Uc0 = ',...
    num2str(Uc0),')']);
xlabel('Zeit in s');   grid on;
legend('ug', 'uc');

% ------- Numerische Lsung (Euler Verfahren)
%Tfinal = 20*T;    % Darstellungszeit
%dt = T/200;       % Zeitschritt
%t = 0:dt:Tfinal;
%nt = length(t);

uc = zeros(1,nt);
uc(1) = Uc0;

% Numerische Annaeherung
for k = 1:nt-1
    uc(k+1) = uc(k) + dt*(ug(k) - uc(k))/tau;
end;

figure(2);
plot(t, ug, t, uc);
title(['Ersatzspannung ug,  und Spannung  uc (Uc0 = ',...
    num2str(Uc0),')']);
xlabel('Zeit in s');   grid on;
legend('ug', 'uc');





