% Skript RC_sinus2.m in dem die Reihenschaltung
% RC fr eine sinusfrmige Anregung untersucht wird.

clear;

% ------- Parameter der Schaltung
R = 50;       C = 0.0001;
uc0 = -15;

ug_ampl = 10;
f = 100;       T = 1/f;
omega = 2*pi*f;
phi = pi/3; 

% ------- Lsung
RC = R*C;     % Zeitkonstante
uc_ampl = ug_ampl/(sqrt((omega*R*C)^2 + 1));
phi_c = atan2(-omega*R*C,1);

C_h = uc0 - uc_ampl*cos(phi + phi_c);
% Zeitachse
dt = T/100;
Tfinal = 5*T;
t = 0:dt:Tfinal;

uc = C_h*exp(-t/RC) + uc_ampl*cos(omega*t + phi + phi_c);
ug = ug_ampl*cos(omega*t + phi);
uR = ug - uc; 

figure(1);
plot(t, ug, t, uc, t, uR);
title('Spannung ug,  uc,  uR');
xlabel('Zeit in s');   grid on;
legend('ug', 'uc', 'uR');

% ------- Numerische Lsung (Euler Verfahren)
dt1 = T/500;    % Sehr kleine Schrittweite
Tfinal = 5*T;
t = 0:dt1:Tfinal;
nt = length(t);
ug = ug_ampl*cos(omega*t + phi);

uc = zeros(1,nt);
uc(1) = uc0;
% Numerische Annaeherung
for k = 1:nt-1
    uc(k+1) = uc(k) + dt1*(ug(k) - uc(k))/RC;
end;
uR = ug - uc;

figure(2);
plot(t, ug, t, uc, t, uR);
title('Spannung ug,  uc,  uR');
xlabel('Zeit in s');   grid on;
legend('ug', 'uc', 'uR');




