% Skript RC_gleichricht1.m in dem die Reihenschaltung
% RC fr die Glttung einer einweg Gleichrichtung 
% eingesetzt wird

clear;

% ------- Parameter der Schaltung
Rs = 50;       C = 0.0002;
uc0 = -10;
Rg = 10;
ug_ampl = 10;
f = 100;       T = 1/f;
omega = 2*pi*f;
phi = pi/4; 

% ------- Numerische Lsung (Euler Verfahren)
dt = T/100;    % Sehr kleine Schrittweite
Tfinal = 6*T;
t = 0:dt:Tfinal;
nt = length(t);
ug = ug_ampl*cos(omega*t + phi);

uc = zeros(1,nt);
ig = zeros(1,nt);
uc(1) = uc0;
% Numerische Annaeherung
for k = 1:nt-1
    ig(k) = (ug(k)- uc(k))/Rg;
    if ig(k) < 0
        ig(k) = 0;
    end;    
    uc(k+1) = uc(k) + dt*(ig(k) - uc(k)/Rs)/C;
end;

figure(1);
plot(t, ug, t, uc, t, 5*ig);
title('Spannung ug,  uc,  Strom 5*ig');
xlabel('Zeit in s');   grid on;
legend('ug', 'uc', '5*ig');




