% Skript RC_glaett1.m, in dem die Reihenschaltung
% RC fr die Glttung einer pulsfrmigen Spannung
% eingesetzt wird

clear;
% ------- Parameter der Schaltung
R = 50;       C = 0.0002;
uc0 = -5;
ug_ampl = 10;
f = 100;       T = 1/f;
omega = 2*pi*f;		phi = pi/4; 
% ------- Numerische Lsung (Euler Verfahren)
RC = R*C;
dt1 = RC/500;    % Sehr kleine Schrittweite
Tfinal = 10*RC;
t = 0:dt1:Tfinal;
nt = length(t);
ug = cos(omega*t + phi);
schwelle = 0;    % Schwelle fr die Umwandlung einer
% Sinusfunktion in eine rechteckige Funktion
%schwelle = -0.8;
ug = (sign(ug - schwelle)+1)*ug_ampl/2;

uc = zeros(1,nt);
uc(1) = uc0;
% Numerische Annaeherung
for k = 1:nt-1
    uc(k+1) = uc(k) + dt1*(ug(k) - uc(k))/RC;
end;
uR = ug - uc;
figure(1);
plot(t, ug, t, uc, t, uR);
title('Spannung ug,  uc,  uR');
xlabel('Zeit in s');   grid on;
legend('ug', 'uc', 'uR');

figure(2);
subplot(211), plot(t, ug, t, uc);
title('Spannung ug und uc');
xlabel('Zeit in s');   grid on;
La = axis; axis([La(1:3), 11]);

subplot(212), plot(t, uR);
title('Spannung uR');
xlabel('Zeit in s');   grid on;



