% Skript RC_2.m in dem die Antwort
% einer Reihenschaltung RC auf eine 
% konstante Spannung, die bei t = 0 
% zugeschaltet wird

clear

% ------ Parameter der Schaltung
R = 100;
C = 0.001;
RC = R*C;
Ug = 10;
Uc0 = -5;

% ------ Zeitverhalten
Tfinal = 5*RC;    % Darstellungszeit
dt = RC/100;      % Zeitschritt
t = 0:dt:Tfinal;
nt = length(t);

uc = Uc0*exp(-t/RC) + Ug*(1-exp(-t/RC));
ug = Ug*ones(1,nt);  % Eingangsspannung
uR = (ug-uc);        % Spannung am Widerstand       
iR = uR/R;           % Strom des Kondensators


%#####################
figure(1);
plot(t, ug, t, uc, t, uR)
title(['Eingangsspannung, Spannung am Kondensator und am Widerstand (Uc0 = ',...
    num2str(Uc0),')']);
xlabel('Zeit in s');  grid on;
umax = max(Ug, max(uR))
La = axis;   axis([La(1:3), umax*1.2]);


% ------- Numerische Lsung (Euler Verfahren)
dt1 = RC/200;    % Sehr kleine Schrittweite
Tfinal = 5*RC;
t = 0:dt1:Tfinal;

nt = length(t);
ug = Ug*ones(1,nt);
uc = zeros(1,nt);
uc(1) = Uc0;

% Numerische Annaeherung
for k = 1:nt-1
    uc(k+1) = uc(k) + dt1*(ug(k) - uc(k))/RC;
end;
uR = ug - uc;

figure(2);
plot(t, ug, t, uc, t, uR);
title('Spannung ug,  uc,  uR');
xlabel('Zeit in s');   grid on;
legend('ug', 'uc', 'uR');

