% Skript RC_1.m in dem die Antwort
% einer Reihenschaltung RC auf eine 
% konstante Spannung, die bei t = 0 
% zugeschaltet wird, ermittelt ist

clear

% ------ Parameter der Schaltung
R = 100;
C = 0.001;
RC = R*C;
Ug = 10;
Uc0 = 0;

% ------ Zeitverhalten
Tfinal = 5*RC;    % Darstellungszeit
dt = RC/100;      % Zeitschritt
t = 0:dt:Tfinal;
nt = length(t);

uc = Uc0*exp(-t/RC) + Ug*(1-exp(-t/RC));
ug = Ug*ones(1,nt);  % Eingangsspannung
uR = (ug-uc);        % Spannung am Widerstand       
iR = uR/R;           % Strom des Kondensators


%#####################
figure(1);
plot(t, ug, t, uc, t, uR)
title(['Eingangsspannung, Spannung am Kondensator und am Widerstand (Uc0 = ',...
    num2str(Uc0),')']);
xlabel('Zeit in s');  grid on;
umax = max(Ug, max(uR))
La = axis;   axis([La(1:3), umax*1.2]);


