\name{PScv}
\alias{PScv}
\title{ Compute the Weighted Voting Statistics Using Cross Validation. }
\description{
  The weighted voting statistics described in Golub et al are computed
  using leave one out cross-validation.
}
\usage{
PScv(eset, cov)
}
\arguments{
  \item{eset}{An object of class \code{exprSet} that contains the
    expression data to be analysed. }
  \item{cov}{A vector indicating which of two classes each sample
    belongs to. }
}
\details{
  Each sample is left out in turn and an object of class \code{vstruct}
  is computed using the remaining samples. This object is then used,
  together with the left out sample to obtain the votes and PS for the
  left out sample. The function returns a list with one entry for each
  sample. 
}
\value{
A list with one entry for each sample. The entries are the output of
\code{\link{dovote}} and are described there.
}
\references{ Molecular Classification of Cancer: Class Discovery and
  Class Prediction by 
Gene Expression Monitoring, Science, 531-537, 1999, T. R. Golub and
D. K. Slonim and P. Tamayo and C. Huard and M. Gaasenbeek and
J. P. Mesirov and H. Coller and M.L. Loh and J. R. Downing and
M. A. Caligiuri and C. D. Bloomfield and E. S. Lander
}
\author{R. Gentleman}

\seealso{\code{\link{dovote}}}

\examples{
   library(golubEsets)
   ans <- PScv(golubTrain[1:20,], golubTrain$ALL)
}
\keyword{manip}
