(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    141448,       2953]
NotebookOptionsPosition[    138966,       2877]
NotebookOutlinePosition[    139306,       2892]
CellTagsIndexPosition[    139263,       2889]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    StyleBox[
     RowBox[{
      RowBox[{"Calculations", " ", "for", " ", "P"}], "\[LessEqual]", "1"}],
     FontSize->16], 
    StyleBox[":",
     FontSize->16], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    SubscriptBox["K", "T"]}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "  ", 
       SubscriptBox["V", "r"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["P", "r"], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
       RowBox[{"108", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", 
      ")"}]}]]}]}]], "Input",
 CellChangeTimes->{{3.5975188797442117`*^9, 3.597518881210614*^9}, {
  3.817200715360182*^9, 3.817200777912357*^9}, {3.817200936450493*^9, 
  3.8172009368567266`*^9}, {3.817303761943244*^9, 3.8173038096578712`*^9}, {
  3.8173118435076895`*^9, 3.8173118721559067`*^9}, {3.817312223066951*^9, 
  3.8173122624994726`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  SubscriptBox["G", "1"], "=", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"5", "  ", 
      SubscriptBox["V", "r"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
      RowBox[{"108", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", 
     ")"}]}]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["G", "2"], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "  ", 
       SubscriptBox["V", "r"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0.5", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
       RowBox[{"108", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["G", "3"], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "  ", 
       SubscriptBox["V", "r"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0.7", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
       RowBox[{"108", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["G", "4"], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "  ", 
       SubscriptBox["V", "r"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1.0", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
       RowBox[{"108", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "1.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["G", "1"], ",", 
       SubscriptBox["G", "2"], ",", 
       SubscriptBox["G", "3"], ",", 
       SubscriptBox["G", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["V", "r"], ",", "0.4", ",", "1.6"}], "}"}], ",", 
     RowBox[{"PlotLegend", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=0.1\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=0.5\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=0.7\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1.0\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["V", "r"], ",", 
        RowBox[{
         SubscriptBox["P", "c"], " ", 
         SubscriptBox["K", "T"]}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue", ",", " ", "Green", ",", "Black"}], " ", 
       "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<reduced pressure \!\(\*SubscriptBox[\(P\), \(r\)]\) versus reduced \
volume \!\(\*SubscriptBox[\(v\), \(r\)]\) at several values of reduced \
temperature \!\(\*SubscriptBox[\(T\), \(r\)]\) with \!\(\*SubscriptBox[\(T\), \
\(r\)]\)=0.8,0.9,0.95,1,1.05 from bottom to top.\>\"", ",", 
     "\"\<Graphics\>\""}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", "\[LowerRightArrow]"}], "Input",
 CellChangeTimes->{{3.817200853008663*^9, 3.8172012647086935`*^9}, {
   3.8172013000847745`*^9, 3.817201364961259*^9}, {3.8172013997548532`*^9, 
   3.8172014473433914`*^9}, {3.817201793179757*^9, 3.817201814109703*^9}, {
   3.817202834509085*^9, 3.81720283640351*^9}, {3.817202873112502*^9, 
   3.817202886072554*^9}, {3.8172030406879854`*^9, 3.8172030558638115`*^9}, {
   3.8172031010219126`*^9, 3.817203105871089*^9}, {3.817203293362694*^9, 
   3.8172032943314934`*^9}, {3.817303828165509*^9, 3.817303869972723*^9}, {
   3.8173039259231234`*^9, 3.8173039504440928`*^9}, {3.817303982437009*^9, 
   3.817304079840536*^9}, {3.817304151251732*^9, 3.817304195186966*^9}, {
   3.8173044855771613`*^9, 3.8173044879057493`*^9}, {3.8173046374775677`*^9, 
   3.8173047022439957`*^9}, {3.8173048494825983`*^9, 3.817304859640786*^9}, {
   3.8173049050780373`*^9, 3.817304959690895*^9}, {3.817305012752576*^9, 
   3.817305064079894*^9}, {3.8173051379604845`*^9, 3.8173051708736043`*^9}, {
   3.817305204615045*^9, 3.81730520652127*^9}, {3.8173054602309885`*^9, 
   3.8173055510181866`*^9}, {3.817305609924472*^9, 3.817305645704286*^9}, {
   3.817305685480137*^9, 3.81730568748075*^9}, {3.8173058233803897`*^9, 
   3.8173058289909353`*^9}, 3.817305971983404*^9, {3.8173071576828003`*^9, 
   3.8173071606994586`*^9}, {3.8173072421400385`*^9, 
   3.8173072625869007`*^9}, {3.817310188080359*^9, 3.817310302847046*^9}, {
   3.8173103654802847`*^9, 3.817310396142927*^9}, {3.8173104619137077`*^9, 
   3.8173105105227957`*^9}, {3.817311063664873*^9, 3.81731109486096*^9}, {
   3.817311140879168*^9, 3.8173111449586267`*^9}, {3.8173112500850835`*^9, 
   3.817311263635173*^9}},
 EmphasizeSyntaxErrors->True],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"5", " ", 
      SubscriptBox["V", "r"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}], "3"]}], 
  RowBox[{"5", " ", 
   SubscriptBox["V", "r"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "108"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}]}], ")"}]}], "+", 
     RowBox[{"0.1`", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"5", " ", 
          SubscriptBox["V", "r"]}]}], ")"}], "3"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.817306038381646*^9, 3.8173071788756075`*^9, 
  3.817307271089071*^9, 3.817307343593128*^9, 3.8173103225174856`*^9, 
  3.8173104109797864`*^9, 3.8173105249162073`*^9, 3.817311109614852*^9, 
  3.8173111620716915`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.817310324158484*^9, 3.8173104126065717`*^9, 
  3.8173105265443993`*^9, 3.8173111112716184`*^9, 3.817311163696705*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TemplateBox[{GraphicsBox[{
     InsetBox[
      GraphicsBox[{{}, {}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVknk0lQsXxg2ZQslMIiTVFVHci/S8udF0NCizJkOD3Io0ISlK3JTKEBGq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          "]], 
         LineBox[CompressedData["
1:eJwV1nk8VF8bAHBlyZJCCNkSipRCIcsjbbYiEYqSQguKpCxFG7IWfslSISGp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          "]], 
         LineBox[{{0.6125541932849177, 14.272584794410806`}, {
          0.6125631003425244, -13.320645129202948`}}]}, {
         RGBColor[0, 0, 1], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVlHc41/0Xxm0ynsyyEiVJkkoLdb+TlCIapIxSaUhlS2YKEZFESgr1oGGl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          "]], 
         LineBox[CompressedData["
1:eJwV1nk8VU8bAHBrWe4tW/Yta1mLEiVPkVIJ2UKJCKmoJNJGIUJISiQVbT9J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          "]], 
         LineBox[{{0.6786058665906483, 14.272584794410806`}, {
          0.6786109240880898, -13.320645129202948`}}]}, {
         RGBColor[0, 1, 0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVlnk0lf3XxiVknjJnalJKkwaFur5JpVB+QpKKSiFTkx7K1KTBkJIkEvVE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          "]], 
         LineBox[CompressedData["
1:eJw92Hk8VN/7AHDizpB93/c1CZWPNjyljRZkTdooklKhkCxJpRAlJSokbVLI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          "]], 
         LineBox[{{0.7305563477736295, 14.272584794410806`}, {
          0.7305603430186717, -13.320645129202948`}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVlmk0Fvoaxc1DogyZXiKZTkclKhmy/9FEqFRIUTmRJDTpRsitUESGW1Jy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          "]], 
         LineBox[CompressedData["
1:eJwVkHs4lAkYxW27Y8s3kVJDrGmYSZOpKEvIvm9bkrvtgnJZGcNS0kXSbi7L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          "]]}}, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
       Axes -> {True, True}, AxesLabel -> {None, None}, 
       AxesOrigin -> {0.4, 0}, DisplayFunction :> $DisplayFunction, 
       FormatType -> TraditionalForm, Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{
          FormBox[
           RowBox[{
             SubscriptBox["P", "c"], " ", 
             SubscriptBox["K", "T"]}], TraditionalForm], None}, {
          FormBox[
           SubscriptBox["V", "r"], TraditionalForm], None}}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
       PlotRange -> {{0.4, 1.6}, {-13.320645129202948`, 14.272584794410806`}},
        PlotRangeClipping -> True, PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, 
       Ticks -> {Automatic, Automatic}], {-1, -0.6180339887498948}, {
      Left, Bottom}, {2, 1.2360679774997896`}], 
     InsetBox[
      StyleBox[
       RowBox[{
         RowBox[{
           SubscriptBox["P", "r"], "=", "0.1"}], ",", "0.5", ",", "0.7", ",", 
         "1"}], FontSize -> 14], 
      Scaled[{1.5523146745704164`, 1.2979928182474612`}], Center], {
      EdgeForm[{
        GrayLevel[0.], 
        Opacity[1.], 
        AbsoluteThickness[1]}], 
      EdgeForm[None], 
      ArrowBox[{{-0.5674167931998386, 
       0.3281953603881888}, {-0.5674167931998386, 0.3281953603881888}}]}, {
      GrayLevel[0.5], 
      Opacity[0.4], 
      ArrowBox[{{-0.6017397886446443, 
       0.3396363588697906}, {-0.6017397886446443, 0.3396363588697906}}]}, 
     InsetBox[
      StyleBox[
       RowBox[{"(", "a", ")"}], FontSize -> 14, FontWeight -> "Bold"], 
      Scaled[{1.4864145227297247`, 0.46191985253851}], Center], {
      GrayLevel[0.5], 
      AbsoluteThickness[1.6], 
      Opacity[0.4], 
      StrokeForm[{
        RGBColor[1, 0, 0], 
        Opacity[1.]}], 
      EdgeForm[{
        RGBColor[1., 0., 0.], 
        Opacity[1.], 
        AbsoluteThickness[1.6]}], 
      EdgeForm[None], 
      ArrowBox[{{-0.5941124563235765, 
       0.48836933913061586`}, {-0.5941124563235765, 0.48836933913061586`}}]}},
     AspectRatio -> Automatic, Background -> None, ColorOutput -> Automatic, 
    ImagePadding -> {{0., 388.859504}, {1., 187.763676}}, 
    ImageSize -> {662., Automatic}, 
    PlotRange -> {{-1.5208333333333333`, -0.4791666666666667}, \
{-1.138033988749895, -0.09803398874989479}}, PlotRangePadding -> Automatic],
   "\[Placeholder]"},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.817311242989719*^9, 3.817311243114718*^9}, {
  3.8173114341709013`*^9, 3.817311434670904*^9}, {3.817807272373991*^9, 
  3.8178072983966465`*^9}, {3.8178073394538155`*^9, 3.8178073510193715`*^9}, {
  3.8178268966826124`*^9, 3.817826903715335*^9}, {3.8179225012477756`*^9, 
  3.8179225129558907`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.8173045043793097`*^9, 3.817304719811025*^9, 3.8173048781340895`*^9, 
   3.817304976633809*^9, 3.8173050880862026`*^9, {3.8173051581206093`*^9, 
   3.817305187190047*^9}, 3.8173052236038885`*^9, 3.8173055703817625`*^9, 
   3.817305668132385*^9, 3.8173057191451645`*^9, 3.817306021015398*^9, {
   3.8173069939378448`*^9, 3.8173069957355814`*^9}, {3.817311447314149*^9, 
   3.817311447800494*^9}, {3.817825637274359*^9, 3.8178256392746205`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.817305743105795*^9, 3.817305743277644*^9}, {
  3.8173059787193813`*^9, 3.8173059789069047`*^9}, {3.8173067951551313`*^9, 
  3.817306797718131*^9}, {3.817306955289241*^9, 3.8173069559298177`*^9}}],

Cell[BoxData[
 TemplateBox[{"","\[Placeholder]"},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173053326162395`*^9, 3.8173053370705633`*^9}, {
   3.817305389771446*^9, 3.8173053978200674`*^9}, 3.8173057875545464`*^9, {
   3.8173069989505157`*^9, 3.817307003654851*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173045356059265`*^9, 3.817304554848611*^9}, 
   3.8173057904771657`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.817304237572505*^9, 3.817305793540371*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.8172030701207147`*^9, 3.8172033150748053`*^9, {3.8173041374648666`*^9, 
   3.8173041412471504`*^9}, 3.81730421089454*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.8172030701207147`*^9, 3.8172033150748053`*^9, {3.8173041374648666`*^9, 
   3.8173041412471504`*^9}}]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173057986665826`*^9, 3.817305798729027*^9}}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.5975174660301437`*^9, 3.5975189881956005`*^9, 
  3.8172018830913095`*^9}]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173058018082085`*^9, 3.8173058018706813`*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.5975190134208446`*^9, 3.597519059768525*^9, 
  3.8173058081065063`*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.5975188343013325`*^9, 3.8173065944921517`*^9, {3.817306639659274*^9, 
   3.817306681843357*^9}, {3.817307016266657*^9, 3.817307016782318*^9}, 
   3.824630541461063*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.597517875452858*^9, 3.597518030532728*^9}, {
   3.5975181261920953`*^9, 3.5975181391245174`*^9}, 3.597518290598784*^9, {
   3.5975188939870367`*^9, 3.597518894517437*^9}, {3.817306605964283*^9, 
   3.8173066127940297`*^9}, {3.8173066991601677`*^9, 3.817306760225036*^9}, 
   3.817306839900573*^9, {3.8173069053089066`*^9, 3.8173069415203905`*^9}, {
   3.817307417315091*^9, 3.8173074449269753`*^9}, {3.8173075255526447`*^9, 
   3.817307527632196*^9}, 3.817307604764301*^9, {3.817307771823846*^9, 
   3.8173077879526787`*^9}, {3.8173078205736947`*^9, 3.81730783967153*^9}, {
   3.8173107835726247`*^9, 3.8173108383506036`*^9}, {3.8173112775763273`*^9, 
   3.817311340139752*^9}, 3.8246305464487667`*^9}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.824630555684987*^9, 3.8246305557318354`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.817307856988196*^9, 3.817307957715592*^9, 
  3.8173108612965097`*^9, 3.8173113565652246`*^9}]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173113711161613`*^9, 3.81731137125673*^9}, 
   3.817825208268503*^9, 3.8246305585297103`*^9}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.817307967217348*^9, 3.817307992258135*^9}, {
  3.8173114636317053`*^9, 3.8173114643817153`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["C", "P"], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"3", " "}], 
     RowBox[{" ", "2", " "}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["P", "r"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", 
        "108"}], " ", ")"}], " "}], 
     RowBox[{" ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["P", "r"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
        RowBox[{"108", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
      " "}]]}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.8178252604996724`*^9, {3.817825298776763*^9, 3.817825302777706*^9}, {
   3.817825340375429*^9, 3.817825364895903*^9}, {3.823971722751825*^9, 
   3.823971723304306*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  SubscriptBox["G", "1"], "=", 
  RowBox[{
   FractionBox[
    RowBox[{"3", " "}], 
    RowBox[{" ", "2", " "}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0.1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", "108"}],
       " ", ")"}], " "}], 
    RowBox[{" ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0.1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
       RowBox[{"108", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
     " "}]]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["G", "2"], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"3", " "}], 
     RowBox[{" ", "2", " "}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"0.5", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", 
        "108"}], " ", ")"}], " "}], 
     RowBox[{" ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"0.5", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
        RowBox[{"108", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
      " "}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["G", "3"], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"3", " "}], 
     RowBox[{" ", "2", " "}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"0.7", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", 
        "108"}], " ", ")"}], " "}], 
     RowBox[{" ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"0.7", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
        RowBox[{"108", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
      " "}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["G", "4"], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"3", " "}], 
     RowBox[{" ", "2", " "}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1.0", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", 
        "108"}], " ", ")"}], " "}], 
     RowBox[{" ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1.0", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
        RowBox[{"108", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
      " "}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "1.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["G", "1"], ",", 
       SubscriptBox["G", "2"], ",", 
       SubscriptBox["G", "3"], ",", 
       SubscriptBox["G", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["V", "r"], ",", "0.4", ",", "1.6"}], "}"}], ",", 
     RowBox[{"PlotLegend", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=0.1\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=0.5\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=0.7\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1.0\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["V", "r"], ",", 
        RowBox[{
         SubscriptBox["C", "P"], "/", 
         SubscriptBox["Nk", "B"]}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue", ",", " ", "Green", ",", "Black"}], " ", 
       "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<reduced pressure \!\(\*SubscriptBox[\(P\), \(r\)]\) versus reduced \
volume \!\(\*SubscriptBox[\(v\), \(r\)]\) at several values of reduced \
temperature \!\(\*SubscriptBox[\(T\), \(r\)]\) with \!\(\*SubscriptBox[\(T\), \
\(r\)]\)=0.8,0.9,0.95,1,1.05 from bottom to top.\>\"", ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\"\<Graphics\>\""}], 
    "]"}]}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.81730922294462*^9, 3.817309248753028*^9}, {
   3.81730928105886*^9, 3.8173093563279934`*^9}, {3.81730941452857*^9, 
   3.8173094582782674`*^9}, {3.8173114752904887`*^9, 
   3.8173115517443776`*^9}, {3.8173115931010814`*^9, 3.817311634346074*^9}, {
   3.8173116958446145`*^9, 3.817311707675132*^9}, {3.8173118051548576`*^9, 
   3.817311805561112*^9}, 3.817825270721698*^9, {3.817825376445414*^9, 
   3.817825385369645*^9}, {3.817825449696088*^9, 3.8178254550722494`*^9}, {
   3.82397172642852*^9, 3.8239717472654033`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "2"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"108", "+", 
      RowBox[{"0.1`", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}]}], ")"}], "2"]}]}], ")"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"-", "108"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}]}], ")"}]}], "+", 
    RowBox[{"0.1`", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}]}], ")"}], "3"]}]}]]}]], "Output",
 CellChangeTimes->{3.81730925748994*^9, 3.8173093755043125`*^9, 
  3.8173094809407077`*^9, 3.81730958532629*^9, 3.8173096429309855`*^9, 
  3.81731156809136*^9, 3.817311649615362*^9, 3.817311726881941*^9, 
  3.8178254157357235`*^9, 3.817825488068458*^9, 3.8239717523910427`*^9, 
  3.8239717935082765`*^9, 3.8244430700716305`*^9}]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{
     InsetBox[
      GraphicsBox[{{}, {}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVUmk41IsbFYZrvfaGxk7KLkkxeV+yJdtVJMutUDdCEa1kjWyJprKWpWuJ
ZKuUrdLtWrJFCjNmfr+RLLd9sVT6+384z3nOc76c55yj6nfE7QAvDw9P7gr+
z11Orxtyc0ch+tP6AtE+STwUW+hTfH0UOiLqA+kvJFGgwZ1S+fcoxAZcLAtn
SqI19alHU90oDIf3X/w0K4kPybLFka5R6JncSbP8TQqbThwCmaVRaDIpm1Ox
lsKK4rnuC15jMMk78FjvkRTaDZceu7JvDKaoBoFbu6RwSsCHdu3gGPjWqTbs
GpRCjeBnIbfCx6CnQMM3j5DCok23JJ6ljsHf7aytCbzSmNMT6iHUPAbf6W/k
X9hI4/mvH4mENePwtaec1vtcGsM+d/uJqY2DgPEm12qmNHp9LOVeWTcO6VxJ
hytT0qj71v11pcmKbwMvU5ekcXDy/nS/yzh0NDx3WlCTQYXhuPdrEsfhzMkG
8kukDFbVS/5s+G8cRG56Gf/SkEVG7Wz01s8r/vT0UR9DWTxb07H8dHEc7Pdq
f39qLouuNyN5xgSYwHAy3/nETRa/FI/y8agyodrzZZVfnCzSs4qFHd2ZkHOb
N2MbIYt9R4yok61MeNz8XM2lWg7bvzPqlzuYMJJ1b7isSQ5rkxcc5buZsMvy
xO9i/8jhpevtcc4jTFhu80yiTMihZ7/TXNM7JkjIPvSolFiNhH5QW4YyCyys
bc2HT67GL29LAkzjWBDwQJAd707F16cEfv2RzAJ6s6AX6U/FEUpQbnAGC0p7
bsvtCqfifUWjvuJcFlyi7ueEZlLxrFO7qWg9C+4KP8w5103F326NCxMkC1Lz
deZ2W8vjmmCZulTrCahiftxSbqeAw+9TbiQ5TMBQZIKTtacCXjj262q86wQU
P3V7MX9IAXnPzJ497TMBB4QsFkpSFXA25aFjUMQE3NSruCHer4APyoOnt9+Y
gES3efGDPmvQi/tEWYifDXGCEvxJqTSU+ctMmiLMhiV6kuauazTsm70tsEqC
DTsO956Fehpafcp7u7CGDb8v7mGGjtFQe1VY87QxG3h2tyWZ6irikpLi7k5/
NiR2p7vceqGIeV6RF5I72FBYKA4WVsp4rVLEi9LNhnmdtPIdPspYslCsmTDA
BkUr0x9Jx5Xx5pW+lrMsNigdB7eUKmVsfq41FznPhgGbDxtfi6hgqOZb9XpZ
DrQ0tv96FaWCHxybhD5SOWBQfiglJE0FwyMS3hvQOODq3bdNMU8Fj3fIN99S
48Bb+Y6o/nsqeHa/rVulAQeizMsKkr+oYGbh9dii7RyIZzyMyDymilL/BB1k
O3Lgx9CI988EVWT8Z+Ko5MqBnv27u9IYqphj/mx1gQcHgjp3t4jcVcWi0YWa
q/4c6NtcvFiypIq1sm6sC9EcGGafnk1LVcPBDH6z6DoOfHFX/5HVqY6ePxjV
iY0coJ8I7YphquNEkKZy+j0OEKGmmVc/qOOsnS1/fisHjN95K9jJayAv7/m+
pi4O1Mjk2t0J1sANx0X8vxAcGHhYVeFM08SmyfwX3yc58HW9drSysSZa7NS1
55vmgEk0pU3dQRMdDJ30pN5xgKpQbtl1UhP9Zy/MGyxxwJByQ6fglSYy/pRK
PyxFgIO9aIZI6VpU6C1ZDpclIL3r+abg1rVYZG4cdppKwMXAnEHRV2uxmrrL
I0WJALsktURJcS385/lllXJtAg6/+Ry/LVoLv9nK3yGtCDCP2GhvELgOo+5U
as3aEDD69dmiwPl1yKthlvfRnoCO5ZQ0g/J1KL7KO4bHhYCIc6t2nZxah1rN
BduVvAlYH5AvIxa4Hj0NVCb2HCPAL1g9MDZGGxP4HtFLjhPgGNuco1yujTUv
9+fPniLgdjUjcUu/NlJiSz3PxBLAYqcxplR0sH5g7VBBBgGutEev/urWQZFw
vU52+Urevc8uOm3Ww022fWvXVRFgvHeH97+H9NBP4ci5ozUEzDkN/vkmVw+b
Htdarbqzoi9Y5Got62GA9MZWtccrfdzOnBDt18e2RrP6A0wC7s7m1390MMSZ
8+MSNWwCPJIFqmwDDVHGN+rIN5IAz/aMNRLnDTGI0qabPEOASf6EoMi/hrja
w7K84hsBxysI/Q8ORmilTVI+LhIgz7p1zjTECEOX4wO2/CSAM7PIFr5ohE/K
nqh285HgN1JK939phEfn7QrmJEiQGFy2w5ANmN8zvWQsQ8KDSZkHjowN+PR6
yp6o1SSESKYm87VsQEX7HjkxJRKK9sbPxYkZY3eOc5a+DgnDDybbbe8bo7qZ
e1KYDQlCcXIK9ZtNcINwTNZNexLuLgiGcA6boNVYRQF3Bwm61llHRYtM0O/0
j3p3NxI6HktfPiOyCYselLK37CUhKsf2fe77TVib2jsb7keCdvwfmVd1TLHd
a/5r1QESCk86RL08ZIoTSw6iSsEkXNh3qcbujSnSzD9t5j1FQkbFbKrm182o
K0KzNo8iId02+1sofQuaj9u4RMSQkJLWHuZ1bgt6nck9MHWOhCPeXX5uNDPM
acbs7mwSNutkWKbuM8eKtKBCviskeOqXKd64a473vBkV9FwSdMKWB2fE6Tjy
/U1bzXUS+GZ+CLg8paMsPXMuu5oE88NBvko7LVBD9P63ntskFDPqDPRbLXAj
k1xFaSDB+V1vtKk24K6oTdQT90ngtzQyYAkgBjjuU69tIeHgPMVjqxXiMVqq
/kw7CfKifyvsj0HMbmFZez8loYv59ZjtL8SSdEFXRtfKPtpnWjdaWWKdj5F3
7zMSKJwrVphsiQM/EsNgaKXPIeEZKtUKxbfqXlPnkPBmHTVO0XMbKol5VPpw
SbBwduPfcnsb6rFiGi9PkUAz2f/4tJA1OkYPdQu+XfnDiPHetZ3W6OP08wV+
IGHaP6D4s64NHlbUIk59JmG52jy75rINpraenp9bJMFXo1iPPGaLeRk3eDV/
kmBPq3pJzNhipW+f2J88XPAf3Wo5EWCHnT9VNQYEuKDWseCrfNgeX/XuMBAS
5oLnnkEtlXl7nC6MNLMS44J4llXx1ZTtKGjR5doozYXInSFaPR0OqODeNH1H
jgtDMnvllvbtQP3g8th78lzojO0vv0pxRI+8c7UPlLngEfKd7v6XEwbVRdi3
qHGhPmrbxUZNZ4zu9Oe0anJhQ3rjNP87Z7zxzVLikQ4XVvsNLHNcXLGFaSx9
Xp8LjDzB0ewWV/wfzg2Bvw==
          "]], 
         LineBox[CompressedData["
1:eJwVj2k4lIsfhlVIJGTfGWsimopC/SQKKRJK0VGhSEJIytJGWStKllQojnBs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          "]], 
         LineBox[{{0.6125567505738616, 66.94646287672578}, {
          0.6125608206813044, -57.47704105016914}}]}, {
         RGBColor[0, 0, 1], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVkWk4lIsfhqVQlo5lZowlJCRkzVLK70coJcmWpFRCOcqeULQh/pbIKUuW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          "]], 
         LineBox[CompressedData["
1:eJwV1nk8lF8XAHCyVCTM2PclS0lkC8mRKGRLCaHsW6IslUpESSlJ1hZKWZKU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          "]], 
         LineBox[{{0.6786071703542712, 66.94646287672578}, {
          0.6786098076839974, -57.47704105016914}}]}, {
         RGBColor[0, 1, 0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVlWk41IsfxWWrrjDGWAaNfUkGhQj1/ZJC1hQJbSpprkSLiqyJsivKklBC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          "]], 
         LineBox[CompressedData["
1:eJwV13k8VF8bAHBKCyq7ZIkY+76veey7SFEJSUgplVYitCCKsick0SJZskWl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          "]], 
         LineBox[{{0.7305572858542924, 66.94646287672578}, {
          0.7305595858260523, -57.47704105016914}}]}, {
         GrayLevel[0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVjGk4FAobQK1RwigqGoxpDNmyVYzlfVOjUUIqISraiKzlhix9pK6dVBJN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          "]], 
         LineBox[CompressedData["
1:eJwVlHs4lIkfxSehUrGl6CJS3mlQYUwjuXy/kyHjMk21kRirmEqle6ISkcgt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          "]]}}, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
       Axes -> {True, True}, AxesLabel -> {None, None}, 
       AxesOrigin -> {0.4, 0}, DisplayFunction :> $DisplayFunction, 
       FormatType -> TraditionalForm, Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{
          FormBox[
           FractionBox[
            SubscriptBox["C", "P"], 
            SubscriptBox["Nk", "B"]], TraditionalForm], None}, {
          FormBox[
           SubscriptBox["V", "r"], TraditionalForm], None}}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
       PlotRange -> {{0.4, 1.6}, {-57.47704105016914, 66.94646287672578}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, 
       Ticks -> {Automatic, Automatic}], {-1, -0.6180339887498948}, {
      Left, Bottom}, {2, 1.2360679774997896`}], 
     InsetBox[
      StyleBox[
       RowBox[{
         RowBox[{
           SubscriptBox["P", "r"], "=", "0.1"}], ",", "0.5", ",", "0.7", ",", 
         "1"}], FontSize -> 14], 
      Scaled[{1.5869470407802722`, 1.2934134869989664`}], Center], 
     ArrowBox[{{-0.5156412245859416, 
      0.4217074036103998}, {-0.11120846208210855`, 0.2175277565210857}}], 
     InsetBox[
      StyleBox[
       RowBox[{"(", "b", ")"}], FontSize -> 14, FontWeight -> "Bold"], 
      Scaled[{1.2118847361085745`, 0.84281238552505}], Center, {
      0.07460410182109548, 0.04319184842273949}, {{1., 0.}, {0., 1.}}]}, 
    AspectRatio -> Automatic, Background -> None, ColorOutput -> Automatic, 
    ImagePadding -> {{0., 377.710744}, {1., 182.366535}}, 
    ImageSize -> {643., Automatic}, 
    PlotRange -> {{-1.5208333333333333`, -0.4791666666666667}, \
{-1.138033988749895, -0.09803398874989479}}, PlotRangePadding -> Automatic],
   StyleBox["\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) \
versus reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several \
values of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \
\\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.824443085560214*^9, 3.824443111990582*^9}, 
   3.824443165948949*^9, {3.82557926227449*^9, 3.8255792690332255`*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.8239718049355774`*^9, 3.8242202744947033`*^9, 
  3.824220389388671*^9, 3.824220432199342*^9, 3.824630584692164*^9}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.8239717736066275`*^9, 3.8242202283890543`*^9}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.817825513371828*^9, 3.817825541174863*^9}, {
   3.817922561500153*^9, 3.817922570322982*^9}, 3.8244430595683403`*^9}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173117525599804`*^9, 3.817311752763118*^9}, 
   3.824442493428315*^9}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173096487324667`*^9, 3.817309648857419*^9}, 
   3.817309699761591*^9, 3.817825585605937*^9}],

Cell[BoxData[
 TemplateBox[{
  "\[Placeholder]",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173095997986665`*^9, 3.8173096275313125`*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173094961314673`*^9, 3.81730949625644*^9}, {
  3.8173095704481697`*^9, 3.817309579356512*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.817309396540167*^9, 3.8173095183885665`*^9}],

Cell[BoxData[""], "Input"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.817307456930624*^9, 3.8173074570243254`*^9}, 
   3.817307657045899*^9}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173070769442654`*^9, 3.8173070770692096`*^9}, {
   3.817307117673028*^9, 3.817307129707332*^9}, 3.8173076611094165`*^9}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.5975192042111773`*^9, 3.5975192495916567`*^9, 
  3.817307053275934*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.5975191257742405`*^9, {3.5975192553012667`*^9, 3.5975192598564744`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.597518187361802*^9, 3.597518261473533*^9}, {
   3.597518369035721*^9, 3.5975184599610796`*^9}, {3.8173081264619446`*^9, 
   3.8173081467318473`*^9}, {3.817308182447135*^9, 3.817308259169958*^9}, {
   3.817308311995708*^9, 3.817308312965131*^9}, 3.8173084381291203`*^9, 
   3.8173085597711086`*^9, {3.817825594060248*^9, 3.817825594639003*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Set", "::", "write"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Tag \[NoBreak]\\!\\(Plus\\)\[NoBreak] in \[NoBreak]\\!\\(C\
\\_P - C\\_V\\)\[NoBreak] is Protected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/write\\\", ButtonNote -> \
\\\"Set::write\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.817308575713215*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"16", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"5", " ", 
      SubscriptBox["V", "r"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"108", "+", 
     RowBox[{
      SubscriptBox["P", "r"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"5", " ", 
          SubscriptBox["V", "r"]}]}], ")"}], "2"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{
    RowBox[{"-", "108"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}]}], "+", 
   RowBox[{
    SubscriptBox["P", "r"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}]}], ")"}], "3"]}]}]]], "Output",
 CellChangeTimes->{3.8173085757444563`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.597518532828807*^9, 3.5975187214019356`*^9}, 
   3.817308106176577*^9, {3.8173082913956933`*^9, 3.8173083926956105`*^9}, {
   3.8173084413490114`*^9, 3.8173084593376117`*^9}, {3.8173085272012005`*^9, 
   3.817308552457117*^9}, {3.817308728237337*^9, 3.817308840182315*^9}, {
   3.81730889609099*^9, 3.817308970375279*^9}, {3.817309013573784*^9, 
   3.8173090874588165`*^9}, {3.817309128532095*^9, 3.817309161883757*^9}, {
   3.8173095358298244`*^9, 3.8173095423159313`*^9}},
 EmphasizeSyntaxErrors->True],

Cell[BoxData[
 FractionBox[
  RowBox[{"16", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"5", " ", 
      SubscriptBox["V", "r"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"108", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}]}], ")"}], "2"]}], ")"}]}], 
  RowBox[{
   RowBox[{
    RowBox[{"-", "108"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}]}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}], "3"]}]]], "Output",
 CellChangeTimes->{3.817308681534303*^9, 3.817308856998261*^9, 
  3.8173089888643293`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.817308683190962*^9, 3.817308859092764*^9, 
  3.817308990490105*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{"B", "  ", 
   StyleBox["\<\"\\\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\
\\) versus reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at \
several values of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\
\\) with \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from \
bottom to top.\\\"\"\>", "Graphics",
    StripOnInput->False]}], "]"}]], "Input",
 CellChangeTimes->{{3.817308866281945*^9, 3.817308866360042*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.597519302616149*^9, 3.597519360008649*^9, 
  3.817308522684394*^9}]
},
WindowSize->{1350, 669},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (July 1, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1473, 45, 116, "Input"],
Cell[CellGroupData[{
Cell[2056, 69, 7265, 204, 399, "Input"],
Cell[9324, 275, 1026, 33, 55, "Output"],
Cell[10353, 310, 475, 9, 21, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10865, 324, 45928, 799, 493, "Input"],
Cell[56796, 1125, 853, 16, 21, "Message"]
}, Open  ]],
Cell[57664, 1144, 244, 3, 31, "Input"],
Cell[57911, 1149, 893, 19, 47, "Input"],
Cell[58807, 1170, 1137, 24, 47, "Input"],
Cell[CellGroupData[{
Cell[59969, 1198, 1105, 23, 47, "Input"],
Cell[61077, 1223, 532, 12, 21, "Message"],
Cell[61612, 1237, 511, 12, 21, "Message"]
}, Open  ]],
Cell[62138, 1252, 1109, 23, 47, "Input"],
Cell[CellGroupData[{
Cell[63272, 1279, 26, 0, 31, "Input"],
Cell[63301, 1281, 431, 9, 21, "Message"]
}, Open  ]],
Cell[63747, 1293, 1111, 23, 47, "Input"],
Cell[64861, 1318, 1134, 24, 47, "Input"],
Cell[65998, 1344, 219, 4, 31, "Input"],
Cell[66220, 1350, 751, 10, 31, "Input"],
Cell[CellGroupData[{
Cell[66996, 1364, 94, 1, 31, "Input"],
Cell[67093, 1367, 451, 9, 21, "Message"]
}, Open  ]],
Cell[67559, 1379, 1158, 24, 47, "Input"],
Cell[68720, 1405, 1160, 24, 47, "Input"],
Cell[69883, 1431, 1298, 43, 79, "Input"],
Cell[CellGroupData[{
Cell[71206, 1478, 6752, 208, 426, "Input"],
Cell[77961, 1688, 1155, 35, 53, "Output"]
}, Open  ]],
Cell[79131, 1726, 42809, 735, 480, "Input"],
Cell[121943, 2463, 1178, 24, 47, "Input"],
Cell[123124, 2489, 1109, 23, 47, "Input"],
Cell[124236, 2514, 1181, 24, 47, "Input"],
Cell[125420, 2540, 1135, 24, 47, "Input"],
Cell[126558, 2566, 1157, 24, 47, "Input"],
Cell[127718, 2592, 1125, 23, 47, "Input"],
Cell[128846, 2617, 1159, 24, 47, "Input"],
Cell[130008, 2643, 1107, 23, 47, "Input"],
Cell[131118, 2668, 26, 0, 31, "Input"],
Cell[131147, 2670, 120, 2, 31, "Input"],
Cell[131270, 2674, 1185, 24, 47, "Input"],
Cell[132458, 2700, 1134, 24, 47, "Input"],
Cell[133595, 2726, 123, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[133743, 2732, 392, 5, 31, "Input"],
Cell[134138, 2739, 474, 10, 23, "Message"],
Cell[134615, 2751, 854, 31, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135506, 2787, 553, 8, 31, "Input"],
Cell[136062, 2797, 791, 28, 53, "Output"],
Cell[136856, 2827, 438, 10, 21, "Message"]
}, Open  ]],
Cell[137309, 2840, 520, 9, 31, "Input"],
Cell[137832, 2851, 1130, 24, 47, "Input"]
}
]
*)

(* End of internal cache information *)
