(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    102133,       2293]
NotebookOptionsPosition[     99567,       2215]
NotebookOutlinePosition[     99907,       2230]
CellTagsIndexPosition[     99864,       2227]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox[
    RowBox[{
     RowBox[{"Calculations", " ", "for", " ", "P"}], "\[GreaterEqual]", "1"}],
    FontSize->16], 
   StyleBox[":",
    FontSize->16], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   SubscriptBox["K", "T"]}], "=", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"5", "  ", 
      SubscriptBox["V", "r"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["P", "r"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
      RowBox[{"108", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", 
     ")"}]}]]}]], "Input",
 CellChangeTimes->{{3.5975188797442117`*^9, 3.597518881210614*^9}, {
  3.817200715360182*^9, 3.817200777912357*^9}, {3.817200936450493*^9, 
  3.8172009368567266`*^9}, {3.817303761943244*^9, 3.8173038096578712`*^9}, {
  3.8173123152201366`*^9, 3.817312337506364*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  SubscriptBox["G", "1"], "=", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"5", "  ", 
      SubscriptBox["V", "r"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
      RowBox[{"108", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", 
     ")"}]}]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["G", "2"], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "  ", 
       SubscriptBox["V", "r"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1.1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
       RowBox[{"108", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["G", "3"], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "  ", 
       SubscriptBox["V", "r"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1.3", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
       RowBox[{"108", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["G", "4"], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}], "-", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "  ", 
       SubscriptBox["V", "r"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1.5", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
       RowBox[{"108", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "1.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "1.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "r"], "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["G", "1"], ",", 
       SubscriptBox["G", "2"], ",", 
       SubscriptBox["G", "3"], ",", 
       SubscriptBox["G", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["V", "r"], ",", "0.4", ",", "1.6"}], "}"}], ",", 
     RowBox[{"PlotLegend", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1.1\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1.3\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1.5\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["V", "r"], ",", 
        RowBox[{
         SubscriptBox["P", "c"], " ", 
         SubscriptBox["K", "T"]}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue", ",", " ", "Green", ",", "Black"}], " ", 
       "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<reduced pressure \!\(\*SubscriptBox[\(P\), \(r\)]\) versus reduced \
volume \!\(\*SubscriptBox[\(v\), \(r\)]\) at several values of reduced \
temperature \!\(\*SubscriptBox[\(T\), \(r\)]\) with \!\(\*SubscriptBox[\(T\), \
\(r\)]\)=0.8,0.9,0.95,1,1.05 from bottom to top.\>\"", ",", 
     "\"\<Graphics\>\""}], "]"}]}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.817200853008663*^9, 3.8172012647086935`*^9}, {
   3.8172013000847745`*^9, 3.817201364961259*^9}, {3.8172013997548532`*^9, 
   3.8172014473433914`*^9}, {3.817201793179757*^9, 3.817201814109703*^9}, {
   3.817202834509085*^9, 3.81720283640351*^9}, {3.817202873112502*^9, 
   3.817202886072554*^9}, {3.8172030406879854`*^9, 3.8172030558638115`*^9}, {
   3.8172031010219126`*^9, 3.817203105871089*^9}, {3.817203293362694*^9, 
   3.8172032943314934`*^9}, {3.817303828165509*^9, 3.817303869972723*^9}, {
   3.8173039259231234`*^9, 3.8173039504440928`*^9}, {3.817303982437009*^9, 
   3.817304079840536*^9}, {3.817304151251732*^9, 3.817304195186966*^9}, {
   3.8173044855771613`*^9, 3.8173044879057493`*^9}, {3.8173046374775677`*^9, 
   3.8173047022439957`*^9}, {3.8173048494825983`*^9, 3.817304859640786*^9}, {
   3.8173049050780373`*^9, 3.817304959690895*^9}, {3.817305012752576*^9, 
   3.817305064079894*^9}, {3.8173051379604845`*^9, 3.8173051708736043`*^9}, {
   3.817305204615045*^9, 3.81730520652127*^9}, {3.8173054602309885`*^9, 
   3.8173055510181866`*^9}, {3.817305609924472*^9, 3.817305645704286*^9}, {
   3.817305685480137*^9, 3.81730568748075*^9}, {3.8173058233803897`*^9, 
   3.8173058289909353`*^9}, 3.817305971983404*^9, {3.8173071576828003`*^9, 
   3.8173071606994586`*^9}, {3.8173072421400385`*^9, 3.8173072625869007`*^9}, 
   3.8173125676219845`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"5", " ", 
      SubscriptBox["V", "r"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}], "3"]}], 
  RowBox[{"5", " ", 
   SubscriptBox["V", "r"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "108"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}]}], ")"}]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}]}], ")"}], "3"]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.817306038381646*^9, 3.8173071788756075`*^9, 
  3.817307271089071*^9, 3.817307343593128*^9, 3.817823528664598*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.8178235303688745`*^9}]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8244450506013412`*^9, 3.824445050648174*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{
     InsetBox[
      GraphicsBox[{{}, {}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVllk4F+oaxc1DogyZRTLtUhkqkawvmgiVCikqO5JkaJdOhJyEIjKckpJd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          "]], 
         LineBox[CompressedData["
1:eJwVjns0lAkYxq0alW8ipYZMpmEmTVSUJV32fduS3J1ulMsKQ5RspVK5RagM
RokmmSar1JBkddFxS9LmlmplSJdFcunG983wFe3aP57zO8/5PX88XL+wTUJ1
NTU174n8T/WEJXqtXiRwTliY7XtmilKrEGdDbxK2lBv3FTWZYomW08npISR0
/nbmzcBCU+yo1P4xGE/CHOGptGmkADvp3e9PJZAQ4LIuPOqdAN9a/tVokkRC
mqXz1GnNAuyRx2b7nyZh+g+984HXBfg5c2jFKzEJKWKDt1Y7Bage9uJAfQ4J
4sQd+6e1LkRTTlb/tbskyLLbx/c3mmDx+FaWaRkJpWYFdrkVJmjZqWt74z4J
ZYwWq64iE/xFckZ2q4KEmrC50rPpJug2K9X9/kMSWhiv68vcTTB8SsKjhqck
fHBw1/rRuwDLv+y//PkDCXqBYPNwxgLEZounv/eToFN5uUExaQE+Kvw6NjxA
Aje6xHhMxcfm4L0eI59IsP6798Xu13x81x2srUZN+BINjU9yPjIUvlE6ahRU
FjmUCjfy0aXaZbulHgVM18iQmyIeXnk2e/ylPgUM2Wy5MJaHY12dsiMGFGQu
HdotCOehnLG7r9KQAt89h3jtnjzUcEw6bM+nwKoibnmbKQ+rWqvO+Syj4Fjr
5JzVzcZoPmj+/KQTBa4nNkgXsY1x1pxZjq9jKQhaMl/yScHFj/Wrfw6Io6Cl
obtVr4WLdTGBnMF4Ch4tI2ydHnMxor+MHE2kwPxBoLjhNhc7y30v6qZQkMGy
ubfoLBfz/Is+OUooCOB4hPi5ctHqlr34/i0Krl5cm3KgaT7ucIptzeqiIE32
fJVXOQf5MZ9ns3om/irE1rFFHPx6y2tb5nsKwm38a2/KOJjEsmnL6JvobiWe
FgkcLO0aUqR/pkDHz06rwoWD2kf8O5O/UfDieKPZYLch1l7Z0B0zUwmMbXZ+
jnMMcfG/zKGgX5XgeOfOm+zzbKwPiM+fsl4JS9r7I9xEbNxVT3vn2074l9pe
2rFszDvXW9+7UQnXM72bCoLYyDarzhO6KmFu+9gMH2s2am4/4OHvpYSwoaax
HIUB9pW0V/kcUsKzuKLmNUYGmBt4NXWrXAmmRGlEzVN9rAmLSW4vUMKGC3Vi
3zp97IrwOOl9Y2J/yCmUUaGPRsmaccJiJcTzoj385fp4+ebegwfvKMGNT60M
S9BH2aiV17kaJZwNUwU9WK2P0tOPBa0dSmg7XPDUqFgPJUV9tVsIFViMdtun
XmOhaOCJNc1UQcuwfshkGQujFxTIc7RUcIFaXhubxUI/aai4V0cFkQ7lTFEi
C81Shz0j9FRQvi4ePgawsDp0bDibrwKPikNPmoxY2Gs2g9sNKtjuoBwazJ2D
ywqso/aFq4A4HLrB98/Z6M67WvfHKxUU3hsu+TBLF39EVVz7sGoECp3j07/V
zUQ70T9M+7wRCCQybTem6uDMY0XTyhmjoJMfvudG2gwM7r2QtV44Ctddywfd
A7XRTyMjf6BxFMrWaNVIKqfjaw0rt9zFNCTJpefv+jAx3H7t4k1LaVg5vLyx
34OJmiInTXULGu65S+oMNzNxhY5/7U5LGqRHt01Nt2NihoF4BXcVDdUdccmZ
5kx0MB+YL9tIg2OiQGk8iYl3tkuHcvxpEK2537BKTqDzxevNzkIa+JqG2x7m
EdjzprRgPJCG/CHPvc6XCNQJaBB6h9CQHlGwNjiDwD17R9vZ+2i429a8viqa
QKP4TTXZ0TR8FYU6dm8msOyR9yXHWBoid8V8PONCoNvU4Mjvx2noCzb+ydae
wKiUGCvPBBoUiqro4l8IVGQVyueKaNg/2CvNExAY1nE3qT6Fhs1T5xUH8QjU
mPcw4GgaDUtq1i1czCFweW67YccZGtpWmtpV6RJY39Pz/VQGDTucXwwkaxPo
a/JVYZNJQ/jllV92aBI4Evz9dn8WDRKWYpMZg8DUQo2zEgkNr14a66qpEfgf
oB3IwA==
          "]]}, {
         RGBColor[0, 0, 1], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVl3k8VO8XxzFDWUOSda5ElNLuK+I8pIVEKTuFohAVUamklBZbSVkKkSRk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          "]]}, {
         RGBColor[0, 1, 0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwV1nk4VV0XAHDce5AQISnJR0rKVCop1s5QEZExN00ylohSUd6SeS6USIoo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          "]]}, {
         GrayLevel[0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwV13k4lN0bB3CEFnpLKhJSFC1olYRvWbJUxuuNok22aLWlUpIoKlF4m0hE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          "]]}}, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
       Axes -> {True, True}, AxesLabel -> {None, None}, 
       AxesOrigin -> {0.4, 0}, DisplayFunction :> $DisplayFunction, 
       FormatType -> TraditionalForm, Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{
          FormBox[
           RowBox[{
             SubscriptBox["P", "c"], " ", 
             SubscriptBox["K", "T"]}], TraditionalForm], None}, {
          FormBox[
           SubscriptBox["V", "r"], TraditionalForm], None}}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
       PlotRange -> {{0.4, 1.6}, {0., 13.909066563648649`}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, 
       Ticks -> {Automatic, Automatic}], {-1, -0.6180339887498948}, {
      Left, Bottom}, {2, 1.2360679774997896`}], 
     InsetBox[
      StyleBox[
       RowBox[{
         RowBox[{
           SubscriptBox["P", "r"], "=", "1.5"}], ",", "1.3", ",", "1.1", ",", 
         "1.0"}], FontSize -> 14], 
      Scaled[{0.911856000219434, 1.0189479711915976`}], Center], 
     InsetBox["\[LowerRightArrow]", 
      Scaled[{0.5, 0.5}], Center], 
     InsetBox["\[LowerRightArrow]", 
      Scaled[{0.5, 0.5}], Center], {
      EdgeForm[{
        GrayLevel[0.], 
        Opacity[1.], 
        AbsoluteThickness[1]}], 
      EdgeForm[None], 
      ArrowBox[{{-0.466116667442938, -0.18459934485284912`}, \
{-0.466116667442938, -0.18459934485284912`}}]}, {
      GrayLevel[0.5], 
      AbsoluteThickness[1.6], 
      Opacity[0.4], 
      StrokeForm[{
        RGBColor[0, 1, 0], 
        Opacity[1.]}], 
      EdgeForm[{
        RGBColor[0., 1., 0.], 
        Opacity[1.], 
        AbsoluteThickness[1.6]}], 
      EdgeForm[None], 
      ArrowBox[{{-0.5992166673449764, -0.204766011504673}, \
{-0.5992166673449764, -0.204766011504673}}]}, 
     InsetBox[
      StyleBox[
       RowBox[{"(", "a", ")"}], FontSize -> 14, FontWeight -> "Bold"], 
      Scaled[{1.4558719989284783`, 0.4358666451267399}], Center], {
      GrayLevel[0.5], 
      AbsoluteThickness[1.6], 
      Opacity[0.4], 
      StrokeForm[{
        RGBColor[1, 0, 0], 
        Opacity[1.]}], 
      EdgeForm[{
        RGBColor[1., 0., 0.], 
        Opacity[1.], 
        AbsoluteThickness[1.6]}], 
      EdgeForm[None], 
      ArrowBox[{{-0.5104833340769508, -0.18863267818321394`}, \
{-0.5104833340769508, -0.18863267818321394`}}]}, 
     ArrowBox[{{-0.25638333426396853`, -0.4064326780229133}, \
{-0.47418333410366764`, -0.11199934490628283`}}]}, AspectRatio -> Automatic, 
    Background -> None, ColorOutput -> Automatic, 
    ImagePadding -> {{0., 367.735537}, {1., 177.537515}}, 
    ImageSize -> {626., Automatic}, 
    PlotRange -> {{-1.5208333333333333`, -0.4791666666666667}, \
{-1.138033988749895, -0.09803398874989479}}, PlotRangePadding -> Automatic],
   StyleBox["\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) \
versus reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several \
values of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \
\\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.817307349656885*^9, 3.8173073497662315`*^9}, 
   3.817307381025066*^9, {3.817312484050746*^9, 3.8173125014182696`*^9}, 
   3.8173125331740417`*^9, 3.817803073202622*^9, 3.8178031525945354`*^9, 
   3.8178243248076286`*^9, {3.8179223054341636`*^9, 3.817922315882517*^9}, {
   3.8186119753051443`*^9, 3.8186119909848413`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8173072785910654`*^9, 3.817307278716097*^9}, {
  3.817307320133345*^9, 3.81730733768499*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8173072069133177`*^9, 3.817307207038288*^9}, {
  3.8173072916108713`*^9, 3.817307295674214*^9}}],

Cell[BoxData[
 TemplateBox[{"","\[Placeholder]"},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173060721559606`*^9, 3.8173060722965636`*^9}, {
   3.817306118901359*^9, 3.8173061708995433`*^9}, {3.8173064145117903`*^9, 
   3.817306414527416*^9}, {3.817306496807761*^9, 3.817306524251616*^9}, 
   3.8173069727302737`*^9, {3.8173072010529003`*^9, 3.817307202193491*^9}}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.817306011591206*^9, 3.81730601166936*^9}, 
   3.8173069866556063`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.8173045043793097`*^9, 3.817304719811025*^9, 3.8173048781340895`*^9, 
   3.817304976633809*^9, 3.8173050880862026`*^9, {3.8173051581206093`*^9, 
   3.817305187190047*^9}, 3.8173052236038885`*^9, 3.8173055703817625`*^9, 
   3.817305668132385*^9, 3.8173057191451645`*^9, 3.817306021015398*^9, {
   3.8173069939378448`*^9, 3.8173069957355814`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.817305743105795*^9, 3.817305743277644*^9}, {
  3.8173059787193813`*^9, 3.8173059789069047`*^9}, {3.8173067951551313`*^9, 
  3.817306797718131*^9}, {3.817306955289241*^9, 3.8173069559298177`*^9}}],

Cell[BoxData[
 TemplateBox[{"","\[Placeholder]"},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173053326162395`*^9, 3.8173053370705633`*^9}, {
   3.817305389771446*^9, 3.8173053978200674`*^9}, 3.8173057875545464`*^9, {
   3.8173069989505157`*^9, 3.817307003654851*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173045356059265`*^9, 3.817304554848611*^9}, 
   3.8173057904771657`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.817304237572505*^9, 3.817305793540371*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.8172030701207147`*^9, 3.8172033150748053`*^9, {3.8173041374648666`*^9, 
   3.8173041412471504`*^9}, 3.81730421089454*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.8172030701207147`*^9, 3.8172033150748053`*^9, {3.8173041374648666`*^9, 
   3.8173041412471504`*^9}}]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173057986665826`*^9, 3.817305798729027*^9}}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.5975174660301437`*^9, 3.5975189881956005`*^9, 
  3.8172018830913095`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8173058018082085`*^9, 3.8173058018706813`*^9}, 
   3.8244452284049664`*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.5975190134208446`*^9, 3.597519059768525*^9, 
  3.8173058081065063`*^9, 3.824445231593534*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.5975188343013325`*^9, 3.8173065944921517`*^9, {3.817306639659274*^9, 
   3.817306681843357*^9}, {3.817307016266657*^9, 3.817307016782318*^9}, {
   3.824445154696639*^9, 3.824445159198036*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.597517875452858*^9, 3.597518030532728*^9}, {
   3.5975181261920953`*^9, 3.5975181391245174`*^9}, 3.597518290598784*^9, {
   3.5975188939870367`*^9, 3.597518894517437*^9}, {3.817306605964283*^9, 
   3.8173066127940297`*^9}, {3.8173066991601677`*^9, 3.817306760225036*^9}, 
   3.817306839900573*^9, {3.8173069053089066`*^9, 3.8173069415203905`*^9}, {
   3.817307417315091*^9, 3.8173074449269753`*^9}, {3.8173075255526447`*^9, 
   3.817307527632196*^9}, 3.817307604764301*^9, {3.817307771823846*^9, 
   3.8173077879526787`*^9}, {3.8173078205736947`*^9, 3.81730783967153*^9}, {
   3.8244451617457356`*^9, 3.824445195067325*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.824445236704199*^9, 3.8244452367198343`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.817307856988196*^9, 3.817307957715592*^9, {3.8244452405961094`*^9, 
   3.824445242143518*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.817307967217348*^9, 3.817307992258135*^9}, {
   3.8184112192987013`*^9, 3.818411229302306*^9}, 3.824445210978521*^9}],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.817824541841535*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["C", "P"], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"3", " "}], 
     RowBox[{" ", "2", " "}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["P", "r"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", 
        "108"}], " ", ")"}], " "}], 
     RowBox[{" ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["P", "r"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
        RowBox[{"108", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
      " "}]]}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.817307873055214*^9, 3.817307931990882*^9}, {
  3.8178245225390797`*^9, 3.817824608095992*^9}, {3.8239714133179593`*^9, 
  3.8239714140926604`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    SubscriptBox["G", "1"], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"3", " "}], 
      RowBox[{" ", "2", " "}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", 
         "108"}], " ", ")"}], " "}], 
      RowBox[{" ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
         RowBox[{"108", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
       " "}]]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["G", "2"], "=", 
     RowBox[{
      FractionBox[
       RowBox[{"3", " "}], 
       RowBox[{" ", "2", " "}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1.1", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", 
          "108"}], " ", ")"}], " "}], 
       RowBox[{" ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1.1", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
          RowBox[{"108", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
        " "}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["G", "3"], "=", 
     RowBox[{
      FractionBox[
       RowBox[{"3", " "}], 
       RowBox[{" ", "2", " "}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1.3", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", 
          "108"}], " ", ")"}], " "}], 
       RowBox[{" ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1.3", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
          RowBox[{"108", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
        " "}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["G", "4"], "=", 
     RowBox[{
      FractionBox[
       RowBox[{"3", " "}], 
       RowBox[{" ", "2", " "}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["V", "r"]}], "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1.5", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "2"]}], "+", 
          "108"}], " ", ")"}], " "}], 
       RowBox[{" ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1.5", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SubscriptBox["V", "r"]}], "+", "1"}], ")"}], "3"]}], "-", 
          RowBox[{"108", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SubscriptBox["V", "r"]}], "-", "3"}], ")"}]}]}], " ", ")"}], 
        " "}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["P", "r"], "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["P", "r"], "=", "1.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["P", "r"], "=", "1.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["P", "r"], "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Labeled", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["G", "1"], ",", 
         SubscriptBox["G", "2"], ",", 
         SubscriptBox["G", "3"], ",", 
         SubscriptBox["G", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["V", "r"], ",", "0.4", ",", "1.6"}], "}"}], ",", 
       RowBox[{"PlotLegend", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1.1\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1.3\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[\(P\), \(r\)]\)=1.5\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["V", "r"], ",", 
          RowBox[{
           SubscriptBox["C", "P"], "/", 
           SubscriptBox["Nk", "B"]}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Blue", ",", " ", "Green", ",", "Black"}], " ", 
         "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<reduced pressure \!\(\*SubscriptBox[\(P\), \(r\)]\) versus reduced \
volume \!\(\*SubscriptBox[\(v\), \(r\)]\) at several values of reduced \
temperature \!\(\*SubscriptBox[\(T\), \(r\)]\) with \!\(\*SubscriptBox[\(T\), \
\(r\)]\)=0.8,0.9,0.95,1,1.05 from bottom to top.\>\"", ",", 
       "\"\<Graphics\>\""}], "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.81730922294462*^9, 3.817309248753028*^9}, {
   3.81730928105886*^9, 3.8173093563279934`*^9}, {3.81730941452857*^9, 
   3.8173094582782674`*^9}, {3.817823478681237*^9, 3.8178234877147503`*^9}, 
   3.817824517835043*^9, {3.817824552078519*^9, 3.8178245617372293`*^9}, {
   3.81782462075458*^9, 3.817824641383817*^9}, {3.8239714181809573`*^9, 
   3.8239714390543275`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "2"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"108", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"5", " ", 
          SubscriptBox["V", "r"]}]}], ")"}], "2"]}], ")"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"-", "108"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}]}], ")"}]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}]}], ")"}], "3"]}]]}]], "Output",
 CellChangeTimes->{3.81730925748994*^9, 3.8173093755043125`*^9, 
  3.8173094809407077`*^9, 3.81730958532629*^9, 3.8173096429309855`*^9, 
  3.8178246564182096`*^9, 3.8239714509347205`*^9, 3.8244412336499834`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.82397145307086*^9, 3.824441235322567*^9}]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{
     InsetBox[
      GraphicsBox[{{}, {}, {
         RGBColor[1, 0, 0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwVjGk4FAobQCWiJKOSaDCmMWRfi7G8b2o0SpQ2iQotZKfckKWP1LVXKilN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          "]], 
         LineBox[CompressedData["
1:eJwVlHk4lIsfxSdJJXFL0SJLecegwphGCt/vMGQsk+pGYlzFKBVaRSVbIluS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          "]]}, {
         RGBColor[0, 0, 1], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwV1nk4VO3/B/A2nhRFJKEaFCJbVIQ+HzNzRBFfS6SNsiUSeh4R0WIpg0yi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          "]]}, {
         RGBColor[0, 1, 0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwV1nk4VOsfAHDZKi2IMjOWRNnNHJGU+L7RgoREiZSULRJKlgi5Ivt2bS2W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          "]]}, {
         GrayLevel[0], 
         AbsoluteThickness[1.6], 
         Opacity[1.], 
         LineBox[CompressedData["
1:eJwV1nk8VdsXAHAhFQm5V9dFpnuOh0ohFbJ2oucaIkWjkkL1ilLv1VNyQxmj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          "]]}}, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
       Axes -> {True, True}, AxesLabel -> {None, None}, 
       AxesOrigin -> {0.4, 0}, DisplayFunction :> $DisplayFunction, 
       FormatType -> TraditionalForm, Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{
          FormBox[
           FractionBox[
            SubscriptBox["C", "P"], 
            SubscriptBox["Nk", "B"]], TraditionalForm], None}, {
          FormBox[
           SubscriptBox["V", "r"], TraditionalForm], None}}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
       PlotRange -> {{0.4, 1.6}, {0., 62.37425449707501}}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, 
       Ticks -> {Automatic, Automatic}], {-1, -0.6180339887498948}, {
      Left, Bottom}, {2, 1.2360679774997896`}], 
     InsetBox[
      StyleBox[
       RowBox[{
         RowBox[{
           SubscriptBox["P", "r"], "=", "1.5"}], ",", "1.3", ",", "1.1", ",", 
         "1.0"}], FontSize -> 14], 
      Scaled[{0.9272382401862851, 1.0203916227155148`}], Center], 
     ArrowBox[{{-0.33883409385230046`, -0.3650527580715657}, \
{-0.5186203859416486, -0.12023738160947472`}}], 
     InsetBox[
      StyleBox[
       RowBox[{"(", "b", ")"}], FontSize -> 14, FontWeight -> "Bold"], 
      Scaled[{1.5368285257407772`, 0.4729096843967756}], Center, {
      0.11093196745938498`, 0.04590288308664206}, {{1., 0.}, {0., 1.}}]}, 
    AspectRatio -> Automatic, Background -> None, ColorOutput -> Automatic, 
    ImagePadding -> {{0., 387.68595}, {1., 187.195556}}, 
    ImageSize -> {660., Automatic}, 
    PlotRange -> {{-1.5208333333333333`, -0.4791666666666667}, \
{-1.138033988749895, -0.09803398874989479}}, PlotRangePadding -> Automatic],
   StyleBox["\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) \
versus reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several \
values of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \
\\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8244412439339666`*^9, 3.824441244105853*^9}, 
   3.824441286196345*^9, 3.8244413530880976`*^9, {3.8244413945711813`*^9, 
   3.824441397555972*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{
  3.8239714986245728`*^9, 3.8242198123031373`*^9, {3.8242199730188727`*^9, 
   3.8242199855212*^9}, 3.8242211547504864`*^9, 3.824441495520186*^9}],

Cell[BoxData[
 TemplateBox[{"","\[Placeholder]"},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8178246805042057`*^9, 3.817824707719592*^9}, 
   3.817824743555617*^9, {3.8179223695946817`*^9, 3.8179223829523015`*^9}, {
   3.818411267278328*^9, 3.818411296286085*^9}, {3.8186120650398083`*^9, 
   3.8186121434360723`*^9}, 3.8244414852829905`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{
     InsetBox["", 
      Scaled[{1.504743589365713, 0.7246002599955657}], Center], {
      EdgeForm[{
        GrayLevel[0.], 
        Opacity[1.], 
        AbsoluteThickness[1]}], 
      EdgeForm[None], 
      ArrowBox[{{-0.45432692444423917`, -0.17780602206776175`}, \
{-0.45432692444423917`, -0.17780602206776175`}}]}}, AspectRatio -> Automatic, 
    Background -> None, ColorOutput -> Automatic, 
    ImagePadding -> {{0., 367.14876}, {1., 177.253455}}, 
    ImageSize -> {625., Automatic}, 
    PlotRange -> {{-1.5208333333333333`, -0.4791666666666667}, \
{-1.138033988749895, -0.09803398874989479}}, PlotRangePadding -> Automatic],
   StyleBox["\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) \
versus reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several \
values of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \
\\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173096487324667`*^9, 3.817309648857419*^9}, 
   3.817309699761591*^9, {3.81782478100723*^9, 3.817824824721465*^9}}],

Cell[BoxData[
 TemplateBox[{
  "\[Placeholder]",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173095997986665`*^9, 3.8173096275313125`*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173094961314673`*^9, 3.81730949625644*^9}, {
  3.8173095704481697`*^9, 3.817309579356512*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.817309396540167*^9, 3.8173095183885665`*^9}],

Cell[BoxData[""], "Input"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.817307456930624*^9, 3.8173074570243254`*^9}, 
   3.817307657045899*^9}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{{3.8173070769442654`*^9, 3.8173070770692096`*^9}, {
   3.817307117673028*^9, 3.817307129707332*^9}, 3.8173076611094165`*^9}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.5975192042111773`*^9, 3.5975192495916567`*^9, 
  3.817307053275934*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.5975191257742405`*^9, {3.5975192553012667`*^9, 3.5975192598564744`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.597518187361802*^9, 3.597518261473533*^9}, {
   3.597518369035721*^9, 3.5975184599610796`*^9}, {3.8173081264619446`*^9, 
   3.8173081467318473`*^9}, {3.817308182447135*^9, 3.817308259169958*^9}, {
   3.817308311995708*^9, 3.817308312965131*^9}, 3.8173084381291203`*^9, 
   3.8173085597711086`*^9, {3.817312400161561*^9, 3.8173124008646946`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Set", "::", "write"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Tag \[NoBreak]\\!\\(Plus\\)\[NoBreak] in \[NoBreak]\\!\\(C\
\\_P - C\\_V\\)\[NoBreak] is Protected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/write\\\", ButtonNote -> \
\\\"Set::write\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.817308575713215*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"16", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"5", " ", 
      SubscriptBox["V", "r"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"108", "+", 
     RowBox[{
      SubscriptBox["P", "r"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"5", " ", 
          SubscriptBox["V", "r"]}]}], ")"}], "2"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{
    RowBox[{"-", "108"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}]}], "+", 
   RowBox[{
    SubscriptBox["P", "r"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"5", " ", 
        SubscriptBox["V", "r"]}]}], ")"}], "3"]}]}]]], "Output",
 CellChangeTimes->{3.8173085757444563`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.597518532828807*^9, 3.5975187214019356`*^9}, 
   3.817308106176577*^9, {3.8173082913956933`*^9, 3.8173083926956105`*^9}, {
   3.8173084413490114`*^9, 3.8173084593376117`*^9}, {3.8173085272012005`*^9, 
   3.817308552457117*^9}, {3.817308728237337*^9, 3.817308840182315*^9}, {
   3.81730889609099*^9, 3.817308970375279*^9}, {3.817309013573784*^9, 
   3.8173090874588165`*^9}, {3.817309128532095*^9, 3.817309161883757*^9}, {
   3.8173095358298244`*^9, 3.8173095423159313`*^9}},
 EmphasizeSyntaxErrors->True],

Cell[BoxData[
 FractionBox[
  RowBox[{"16", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"5", " ", 
      SubscriptBox["V", "r"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"108", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SubscriptBox["V", "r"]}]}], ")"}], "2"]}], ")"}]}], 
  RowBox[{
   RowBox[{
    RowBox[{"-", "108"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}]}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"5", " ", 
       SubscriptBox["V", "r"]}]}], ")"}], "3"]}]]], "Output",
 CellChangeTimes->{3.817308681534303*^9, 3.817308856998261*^9, 
  3.8173089888643293`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"PlotLegends`\\\"\\)\[NoBreak] is now \
obsolete. The legacy version being loaded may conflict with current \
functionality. See the Compatibility Guide for updating information.\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.817308683190962*^9, 3.817308859092764*^9, 
  3.817308990490105*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{"B", "  ", 
   StyleBox["\<\"\\\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\
\\) versus reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at \
several values of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\
\\) with \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from \
bottom to top.\\\"\"\>", "Graphics",
    StripOnInput->False]}], "]"}]], "Input",
 CellChangeTimes->{{3.817308866281945*^9, 3.817308866360042*^9}}],

Cell[BoxData[
 TemplateBox[{
  "",StyleBox[
   "\"reduced pressure \\!\\(\\*SubscriptBox[\\(P\\), \\(r\\)]\\) versus \
reduced volume \\!\\(\\*SubscriptBox[\\(v\\), \\(r\\)]\\) at several values \
of reduced temperature \\!\\(\\*SubscriptBox[\\(T\\), \\(r\\)]\\) with \\!\\(\
\\*SubscriptBox[\\(T\\), \\(r\\)]\\)=0.8,0.9,0.95,1,1.05 from bottom to \
top.\"", "Graphics", StripOnInput -> False]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2}], "]"}]& )]], "Input",
 CellChangeTimes->{3.597519302616149*^9, 3.597519360008649*^9, 
  3.817308522684394*^9}]
},
WindowSize->{1350, 669},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (July 1, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1349, 43, 96, "Input"],
Cell[CellGroupData[{
Cell[1932, 67, 6927, 198, 399, "Input"],
Cell[8862, 267, 890, 30, 55, "Output"],
Cell[9755, 299, 380, 8, 21, "Message"]
}, Open  ]],
Cell[10150, 310, 1109, 23, 47, "Input"],
Cell[11262, 335, 28366, 512, 468, "Input"],
Cell[39631, 849, 142, 2, 31, "Input"],
Cell[39776, 853, 145, 2, 31, "Input"],
Cell[39924, 857, 991, 20, 47, "Input"],
Cell[CellGroupData[{
Cell[40940, 881, 119, 2, 31, "Input"],
Cell[41062, 885, 755, 15, 21, "Message"]
}, Open  ]],
Cell[41832, 903, 244, 3, 31, "Input"],
Cell[42079, 908, 893, 19, 47, "Input"],
Cell[42975, 929, 1137, 24, 47, "Input"],
Cell[CellGroupData[{
Cell[44137, 957, 1105, 23, 47, "Input"],
Cell[45245, 982, 532, 12, 21, "Message"],
Cell[45780, 996, 511, 12, 21, "Message"]
}, Open  ]],
Cell[46306, 1011, 1109, 23, 47, "Input"],
Cell[CellGroupData[{
Cell[47440, 1038, 26, 0, 31, "Input"],
Cell[47469, 1040, 431, 9, 21, "Message"]
}, Open  ]],
Cell[47915, 1052, 124, 2, 31, "Input"],
Cell[48042, 1056, 141, 2, 31, "Input"],
Cell[48186, 1060, 243, 4, 31, "Input"],
Cell[48432, 1066, 673, 9, 31, "Input"],
Cell[49108, 1077, 94, 1, 31, "Input"],
Cell[49205, 1080, 505, 12, 21, "Message"],
Cell[49713, 1094, 1181, 24, 47, "Input"],
Cell[50897, 1120, 87, 1, 52, "Input"],
Cell[50987, 1123, 1275, 42, 79, "Input"],
Cell[CellGroupData[{
Cell[52287, 1169, 7007, 208, 448, "Input"],
Cell[59297, 1379, 970, 31, 53, "Output"],
Cell[60270, 1412, 412, 9, 21, "Message"]
}, Open  ]],
Cell[60697, 1424, 23609, 416, 492, "Input"],
Cell[84309, 1842, 1208, 25, 47, "Input"],
Cell[85520, 1869, 967, 20, 47, "Input"],
Cell[86490, 1891, 1824, 37, 468, "Input"],
Cell[88317, 1930, 1125, 23, 47, "Input"],
Cell[89445, 1955, 1159, 24, 47, "Input"],
Cell[90607, 1981, 1107, 23, 47, "Input"],
Cell[91717, 2006, 26, 0, 31, "Input"],
Cell[91746, 2008, 120, 2, 31, "Input"],
Cell[91869, 2012, 1185, 24, 47, "Input"],
Cell[93057, 2038, 1134, 24, 47, "Input"],
Cell[94194, 2064, 123, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[94342, 2070, 394, 5, 31, "Input"],
Cell[94739, 2077, 474, 10, 23, "Message"],
Cell[95216, 2089, 854, 31, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96107, 2125, 553, 8, 31, "Input"],
Cell[96663, 2135, 791, 28, 53, "Output"],
Cell[97457, 2165, 438, 10, 21, "Message"]
}, Open  ]],
Cell[97910, 2178, 520, 9, 31, "Input"],
Cell[98433, 2189, 1130, 24, 47, "Input"]
}
]
*)

(* End of internal cache information *)
