
# MF-DFA Method -----------------------------------------------------------

mfdfa <- function (x, scale = NA, q = -5:5, m = 1, overlap = FALSE){
  ret <- list()
  ret$x <- x
  X <- cumsum(x - mean(x))
  l <- length(X)
  if (is.na(scale[1])) 
    scale <- round(logseq(32, l/10, n = 20))
  ls <- length(scale)
  lq <- length(q)
  qRMS <- Fq <- matrix(NA, lq, ls)
  seg <- list()
  segments <- matrix(NA, ls, 1)
  Hq <- matrix(NA, lq, ls)
  seg <- list()
  if (!overlap) {
    for (i in 1:ls) {
      seg[[i]] <- floor(length(X)/scale[i])
      rmvi <- c()
      for (vi in 1:seg[[i]]) {
        Index = ((((vi - 1) * scale[i]) + 1):(vi * scale[i]))
        C <- polyfit(Index, X[Index], m)
        fit <- polyval(C, Index)
        rmvi[vi] <- sqrt(mean((X[Index] - fit)^2))
      }
      for (nq in 1:lq) {
        qRMS <- rmvi^q[nq]
        Fq[nq, i] <- mean(qRMS)^(1/q[nq])
      }
      Fq[which(q == 0), i] <- exp(0.5 * mean(log(rmvi^2)))
    }
  }
  else {
    for (ns in 1:ls) {
      cat(".")
      segs <- scale[ns]
      if (segs == l) {
        Index <- 1:l
        C <- polyfit(Index, X[Index], m)
        fit <- polyval(C, Index)
        rms <- sqrt(mean((X[Index] - fit)^2))
      }
      else {
        rms <- rep(NA, l - segs)
        for (v in 1:(l - segs)) {
          Index <- v:(v + segs)
          C <- polyfit(Index, X[Index], m)
          fit <- polyval(C, Index)
          rms[v] <- sqrt(mean((X[Index] - fit)^2))
        }
      }
      for (nq in 1:lq) {
        qRMS <- rms^q[nq]
        Fq[nq, ns] <- mean(qRMS)^(1/q[nq])
      }
      Fq[which(q == 0), ns] <- exp(0.5 * mean(log(rms^2)))
    }
  }
  Hq <- R2 <- rep(NA, lq)
  x <- log(scale)
  for (j in 1:lq) {
    y <- log(Fq[j, ])
    mdl <- lm(y ~ x)
    if (q[j] == 2) 
      ret$fit2 <- mdl
    Hq[j] <- mdl$coefficients[2]
    R2[j] <- cor(y, mdl$fitted.values)^2
  }
  ret$Fq <- Fq
  ret$Hq <- Hq
  ret$n <- l
  ret$scale <- scale
  ret$q <- q
  tq <- Hq * q - 1
  alpha <- diff(tq)/diff(q)
  f_alpha <- (q[1:(lq - 1)] * alpha) - tq[1:(lq - 1)]
  ret$alpha <- alpha
  ret$tq <- tq
  ret$f_alpha <- f_alpha
  ret$R2 <- R2
  ret$m <- m
  class(ret) <- "multifractal"
  return(ret)
}

# Local Hurst Exponent ----------------------------------------------------

local_H <- function (mdl, scale = 5:21, m = 1, align = "center"){
  if (class(mdl) != "multifractal") 
    stop("The input 'mdl' is not of class 'multifractal'. Pleas use the 'mfdfa' to create 'mdl'.")
  x <- mdl$x
  n <- length(x)
  ls <- length(scale)
  X <- cumsum(x - mean(x))
  RMS <- list()
  for (ns in 1:ls) {
    rms <- rep(NA, n)
    sc <- scale[ns]
    cat(sc)
    for (v in 1:(n - sc)) {
      Index <- v:(v + sc - 1)
      C <- polyfit(Index, X[Index], m)
      fit <- polyval(C, Index)
      rms[v] <- sqrt(mean((X[Index] - fit)^2))
    }
    RMS[[ns]] <- rms
  }
  if (align == "center") {
    for (ns in 1:ls) {
      sc <- scale[ns]
      nh <- (sc - 1)/2
      hfil <- rep(NA, nh)
      rms <- RMS[[ns]][1:(n - nh)]
      if (round(nh) == nh) {
        RMS[[ns]] <- c(hfil, rms)
      }
      else {
        RMS[[ns]] <- c(hfil, NA, rms)
      }
    }
  }
  else if (align == "right") {
    for (ns in 1:ls) {
      rms <- RMS[[ns]]
      RMS[[ns]] <- c(rep(NA, sum(is.na(rms))), na.omit(rms))
    }
  }
  else if (align != "left") {
    warning("alignment misspecified")
  }
  q <- mdl$q
  if (2 %in% q) {
    Hq2 <- mdl$Hq[which(mdl$q == 2)]
  }
  else {
    stop("The moment order 'q' does not contain the value 2. Please re-run 'mfdfa' with 'q' covering 2.")
  }
  fit2 <- mdl$fit2
  Regfit <- fit2$coefficients[1] + fit2$coefficients[2] * 
    log(scale)
  maxL <- n
  Ht <- matrix(NA, n, ls)
  for (ns in 1:ls) {
    rms <- RMS[[ns]]
    resRMS <- Regfit[ns] - log(rms)
    logscale <- log(maxL) - log(scale[ns])
    Ht[, ns] <- resRMS/logscale + Hq2
  }
  iqr <- data.frame(t(apply(Ht, 1, quantile, na.rm = T)))
  res <- cbind(rowMeans(Ht), iqr$X75. - iqr$X25.)
  res <- data.frame(Ht = rowMeans(Ht), iqr = iqr$X75. - iqr$X25.)
  res$iqr[which(is.na(res$Ht))] <- NA
  res[res == 0] <- NA
  rownames(res) <- names(mdl$x)
  class(res)[2] <- "data.frame"
  class(res)[1] <- "localH"
  return(res)
}


# IAAFT -------------------------------------------------------------------

iaaft <- function(x, N=1, xt=x){
  # initialization
  if(missing(xt)) xt <- x
  xs <- sort.int(xt)
  n <- length(x)
  ac_orig <- acf_m(x)
  # first transform
  z <- fft(x)
  A <- Mod(z)
  phi <- Arg(z)
  x_d_mat <- matrix(0, n, N)
  for(k in 1:N){
    phi_dd <- sample(phi)
    z_d <- A*exp(1i*phi_dd)
    err_prev <- 5
    for(i in 1:100){
      # inverse and rank order match
      x_d <- Re(fft(z_d, TRUE))
      x_d[order(x_d)] <- xs
      # check convergence
      ac_d <- acf_m(x_d)
      err <- sum(abs(ac_d - ac_orig))
      err_rel <- (1-err/err_prev)
      if(err < 0.05 || err_rel < 0.01) break
      # prep for next iteration
      err_prev <- err
      z_dp <- fft(x_d)
      z_d <- A*exp(1i*Arg(z_dp))
    }
    x_d_mat[,k] <- x_d
  }
  return(x_d_mat)
}

acf_m <- function(x, m=10) {
  n <- length(x)
  x <- x - mean(x)
  acf_vals <- numeric(5)
  var_x <- sum(x^2) / n
  for (lag in 1:m) {
    acf_vals[lag + 1] <- sum(x[1:(n - lag)] * x[(lag + 1):n]) / (n * var_x)
  }
  return(acf_vals[-1])
}


# Maximum Drawdown --------------------------------------------------------

max_dd <- function(r) -min(cumsum(r) - cummax(cumsum(r)))

