function y = gmfcy_data_OECD20(variable_option, rescale_option)
    % MACRO
% baseline time sample: 1996Q1 - 2019Q4 (T=92)
output_raw = xlsread('gmfcy_data.xlsx','GDP','b66:v161');
output_raw = [output_raw(:,1) output_raw(:,4) output_raw(:,6:11) output_raw(:,13:15) output_raw(:,17:21)];
% Data transfromation
     % qoq log-differences*100 & demean
if rescale_option == 0 || rescale_option == 1
    output_transf = transf_data(output_raw,1);
elseif rescale_option == 2
    output_transf = transf_data(output_raw,2);
end
% FINANCIAL
if variable_option == 1
    inflows_raw = xlsread('gmfcy_data.xlsx','INFLOWS','b66:u161');
    inflows_raw = [inflows_raw(:,1) inflows_raw(:,4) inflows_raw(:,6:11) inflows_raw(:,13:20)]; 
    if rescale_option == 0
        inflows = inflows_raw;
        % Data transfromation (yoy log-differences & demean)
        inflows_transf = transf_data(inflows,0);
    elseif rescale_option == 1
        assets_raw = xlsread('gmfcy_data.xlsx','Assets','b2:v97');
        assets_raw = [assets_raw(:,1) assets_raw(:,4) assets_raw(:,6:11) assets_raw(:,13:15) assets_raw(:,17:21)]; 
        liabilities_raw = xlsread('gmfcy_data.xlsx','Liabilities','b2:v97');
        liabilities_raw = [liabilities_raw(:,1) liabilities_raw(:,4) liabilities_raw(:,6:11) liabilities_raw(:,13:15) liabilities_raw(:,17:21)];
        % Interpolate missing data in A+L
        % Interpolate level data using a shape-preserving piecewise cubic interpolation
        % interp1(t0,y0,t1,'pchip');
        assets_interp = interp1(1:96,assets_raw,1:96,'pchip');
        liab_interp = interp1(1:96,liabilities_raw,1:96,'pchip');
        AL = (assets_interp + liab_interp)/1000; % units in billion now, same as CF
        % Rescale CF data
        inflows = 100*(inflows_raw./AL); % INFLOW
        % Data transfromation (yoy log-differences & demean)
        inflows_transf = transf_data(inflows,0);
    elseif rescale_option == 2
        inflows = inflows_raw;
        % Data transfromation (yoy log-differences & demean)
        inflows_transf = transf_data(inflows,2);
    end
    y = [output_transf inflows_transf];
elseif variable_option == 2
    outflows_raw  = xlsread('gmfcy_data.xlsx','OUTFLOWS','b66:u161');
    outflows_raw = [outflows_raw(:,1) outflows_raw(:,4) outflows_raw(:,6:11) outflows_raw(:,13:20)];  
    if rescale_option == 0 
        outflows = outflows_raw;
    elseif rescale_option == 1
        assets_raw = xlsread('gmfcy_data.xlsx','Assets','b2:v97');
        assets_raw = [assets_raw(:,1) assets_raw(:,4) assets_raw(:,6:11) assets_raw(:,13:15) assets_raw(:,17:21)]; 
        liabilities_raw = xlsread('gmfcy_data.xlsx','Liabilities','b2:v97');
        liabilities_raw = [liabilities_raw(:,1) liabilities_raw(:,4) liabilities_raw(:,6:11) liabilities_raw(:,13:15) liabilities_raw(:,17:21)];
        % Interpolate missing data in A+L
        % Interpolate level data using a shape-preserving piecewise cubic interpolation
        % interp1(t0,y0,t1,'pchip');
        assets_interp = interp1(1:96,assets_raw,1:96,'pchip');
        liab_interp = interp1(1:96,liabilities_raw,1:96,'pchip');
        AL = (assets_interp + liab_interp)/1000; % units in billion now, same as CF
        % Rescale CF data
        outflows = 100*(outflows_raw./AL); % OUTFLOW
    end
    % Data transfromation (yoy log-differences & demean)
    outflows_transf = transf_data(outflows,0);
    y = [output_transf outflows_transf];
elseif variable_option == 3
    h_inflows_raw = xlsread('gmfcy_data.xlsx','HOT_INFLOWS','b66:u161');
    h_inflows_raw = [h_inflows_raw(:,1) h_inflows_raw(:,4) h_inflows_raw(:,6:11) h_inflows_raw(:,13:20)]; 
    if rescale_option == 0
        hot_inflows = h_inflows_raw;
    elseif rescale_option == 1
        assets_raw = xlsread('gmfcy_data.xlsx','Assets','b2:v97');
        assets_raw = [assets_raw(:,1) assets_raw(:,4) assets_raw(:,6:11) assets_raw(:,13:15) assets_raw(:,17:21)]; 
        liabilities_raw = xlsread('gmfcy_data.xlsx','Liabilities','b2:v97');
        liabilities_raw = [liabilities_raw(:,1) liabilities_raw(:,4) liabilities_raw(:,6:11) liabilities_raw(:,13:15) liabilities_raw(:,17:21)];
        assets_interp = interp1(1:96,assets_raw,1:96,'pchip');
        liab_interp = interp1(1:96,liabilities_raw,1:96,'pchip');
        AL = (assets_interp + liab_interp)/1000; % units in billion now, same as CF
        hot_inflows = 100*(h_inflows_raw./AL); % HOT INFLOW
    end
    % Data transfromation (qoq log-differences*100 & demean)
    h_inflows_transf = transf_data(hot_inflows,0);
    y = [output_transf h_inflows_transf];
elseif variable_option == 4
    h_outflows_raw  = xlsread('gmfcy_data.xlsx','HOT_OUTFLOWS','b66:u161');
    h_outflows_raw = [h_outflows_raw(:,1) h_outflows_raw(:,4) h_outflows_raw(:,6:11) h_outflows_raw(:,13:20)]; 
    if rescale_option == 0
        hot_outflows = h_outflows_raw;
    elseif rescale_option == 1
        assets_raw = xlsread('gmfcy_data.xlsx','Assets','b2:v97');
        assets_raw = [assets_raw(:,1) assets_raw(:,4) assets_raw(:,6:11) assets_raw(:,13:15) assets_raw(:,17:21)]; % 
        liabilities_raw = xlsread('gmfcy_data.xlsx','Liabilities','b2:v97');
        liabilities_raw = [liabilities_raw(:,1) liabilities_raw(:,4) liabilities_raw(:,6:11) liabilities_raw(:,13:15) liabilities_raw(:,17:21)]; 
        assets_interp = interp1(1:96,assets_raw,1:96,'pchip');
        liab_interp = interp1(1:96,liabilities_raw,1:96,'pchip');
        AL = (assets_interp + liab_interp)/1000; % units in billion now, same as CF
        hot_outflows = 100*(h_outflows_raw./AL); % HOT OUTFLOW
    end
    % Data transfromation (yoy log-differences & demean)
    h_outflows_transf = transf_data(hot_outflows,0);
    y = [output_transf h_outflows_transf];
elseif variable_option == 5
    credit_raw  = xlsread('gmfcy_data.xlsx','CREDIT','b66:u161');
    credit_raw = [credit_raw(:,1) credit_raw(:,4) credit_raw(:,6:11) credit_raw(:,13:20)];
    % Data transfromation (yoy log-differences & demean)
    credit_transf = transf_data(credit_raw,1);
    y = [output_transf credit_transf];
elseif variable_option == 6
    loans_raw  = xlsread('gmfcy_data.xlsx','LOANS','b66:u161');
    loans_raw = [loans_raw(:,1) loans_raw(:,4) loans_raw(:,6:11) loans_raw(:,13:20)]; 
    % Data transfromation (yoy log-differences & demean)
    loans_transf = transf_data(loans_raw,1);
    y = [output_transf loans_transf];
end

    
end