%% Replication code for key results in 
% “Which Global Cycle? A Stochastic Factor Selection Approach for Global Macro-Financial Cycles”
% by Berger and Hienzsch (2024)

clc; clear all;


addpath(genpath('figures'));
addpath(genpath('functions'));
addpath(genpath('results'));
addpath(genpath('subscripts'));

%% set seed
rng(1234);

%% Options
options.baselineSFS = 1; % option to run baseline model 

%Options for figures (can be run without baselineSFS)
options.FigSave = 1;    % save figure as pdf

options.Figure1   = 1;    % Posterior distributions of the global factor standard deviations.
options.Figure2_3 = 1;    % Figure 2: Estimates of the Selected Global Factors.
                          % Figure 3: Comparison of the different estimates of GMFCy and the unconditional GBCy.
options.Figure4   = 1;    % Robustness Checks: Posterior distributions of the global factor standard deviations.
options.Figure5   = 1;    % Robustness Checks for Global Factors using different financial variables.

%% Baseline results
% run stochastic factor selection 

if options.baselineSFS == 1
    run_GMFCy;
end

%% Get figures

if options.Figure1 == 1
    Figure_1;
end

if options.Figure2_3 == 1
    Figure_2_3;
end

if options.Figure4 == 1
    Figure_4;
end

if options.Figure5 == 1
    Figure_5;
end