function [data_out] = transf_data(data_in,transformation)
%transf_data function for transforming data for SFS study of GMFCy
% Sebastian Hienzsch, Uni Gttingen
% Stand: 13.09.2021
% 
%   Non-stationary data are transformed to year-on-year log-differences
%   All data are demeaned
% -------------------------------------------------------------------------
% INPUTS:
% data_in           - data to be transformed
% transformation    - transformation setting = {0,1}
% -------------------------------------------------------------------------
% OUPUTS:
% data_out
% -------------------------------------------------------------------------

if transformation == 1 % delta log q-on-q
    data_stat = (log(data_in(2:end,:)) - log(data_in(1:end-1,:)))*100;
elseif transformation == 2 % delta log y-on-y
    data_stat = (log(data_in(5:end,:)) - log(data_in(1:end-4,:)))*100;
elseif transformation == 3 % delta log y-on-y
    data_stat = (log(data_in(5:end,:)) - log(data_in(1:end-4,:)))*100;
elseif transformation == 4 % log prices
    data_stat = log(data_in);
else
    data_stat = data_in(2:end,:);  
end


%% Demean
[T,N] = size(data_stat);
data_demean = data_stat - ones(T,1)*mean(data_stat,1);

%% data out
data_out = data_demean;

end

