function [y_tilde] = trans_ar(y, phi)
%trans_ar transform series y to account for AR lag-polynomial \phi(L) of idiosyncratic component \mu_t
% following Chib and Greenberg (1994) -> y_tilde
%   Input: y  -> data series to be transformed
%          pi -> AR lag-polynomial of idiosyncratic component \mu_t
%   Output: y_tilde -> y premultiplied with \phi(L)
T = size(y,1);
p = size(phi,2);

%% First p values (Chib and Greenberg (1994) section 4.1, page 195)

if p==1
   e = 1;
   phi_mat = phi; 
else
    e = [1;zeros(p-1,1)];
    phi_mat = [phi; eye(p-1) zeros(p-1,1)];
    
end

sigma_m = inv(eye(p^2)-kron(phi_mat,phi_mat))*reshape(e*e',p^2,1);
sig_p   = reshape(sigma_m,p,p);
[QQ,v]  = chol(sig_p);

if v==0
    Q = QQ; 
else
    sig_p = eye(p);
    Q = chol(sig_p);      
end

% get first p values
y_ini = inv(Q)*y(1:p,:);

%% Transform times series y to y_tilde 
%   y_dep 
y_trans = zeros(T-p,1);
y_dep   = y((p+1):T,1);
y_reg   = lagmatrix(y,1);

if p>1
   for i = 2:p
       y_reg = [y_reg lagmatrix(y,i)];
   end
end

y_reg   = y_reg((p+1):T,:);
y_trans = y_dep - y_reg*phi';

y_tilde = [y_ini; y_trans];

end

