function [s_G, s_sig_g] = states_G(y,s_F,...
                                s_phi_g, s_phi_mu,...
                                s_sig_g, s_sig_f, s_sig_mu,...
                                s_gam_g, s_gam_f, ...
                                ind_f, lags, ortho)
%states_G Samples the global macro-financial factor using FFBS
%   Forward-filter backward sampler for global common factor
[T,I] = size(y);

%% Transforming data series
%   purge other factor information from series to get y*
%   to cast model into state-space form, need to handle AR-process in \mu_t
%   following Chib and Greenberg (1994) -> y_tilde
y_tilde = zeros(T,I);
ystar   = zeros(T,I);

for i=1:I
   ystar(:,i) = y(:,i) - s_gam_f(i,1)*s_sig_f(ind_f(1,i),1)*s_F(:,ind_f(1,i));
   y_tilde(:,i) = trans_ar(ystar(:,i),s_phi_mu(i,:));
end

%% Sampling global factor by FFBS
%   set up state space matrices
%   Yt = Zt*St   + Vt ,    Vt~N(0,Ht)
%   St = Tt*St-1 + Kt*Et , Et~N(0,Qt)
Kt = zeros(lags+1,1,T); Kt(1,1,:) = 1;
Zt = zeros(I,lags+1,T);
Ht = zeros(I,I,T);
Tt = zeros(lags+1,lags+1);
Tt(1,:) = [s_phi_g 0];
Tt(2:end,1:end-1) = eye(lags);

S0 = zeros(lags+1,1); 
Qt = 1; % normalize variance of innovations to 1

%   initialize var-cov matrix of states
Q1 = zeros((lags+1)^2,1); Q1(1,1) = Qt;
P1 = inv((eye((lags+1)^2)-kron(Tt,Tt)))*Q1;
P0 = reshape(P1',lags+1,lags+1);

for j=1:I
   Zt(j,1,:) = s_gam_g(j,1)*s_sig_g;
   for a = 1:lags
       Zt(j,a+1,:) = -s_phi_mu(j,a)*s_gam_g(j,1)*s_sig_g;
   end
   Ht(j,j,:) = s_sig_mu(j,1)^2;
end

% -------------------------------------------------------------------------
%   Run Kalman filter forward and sampler backward
%   Draw sample s_G
% -------------------------------------------------------------------------
[hStt,hPtt] = Kalman_filter_um(y_tilde, Zt, [], S0, P0, Qt, Tt, Kt, Ht, []);
draws       = Kalman_sampler_um(hStt,hPtt,Tt,Qt,Kt(:,:,1));
s_G         = draws(1,:)';

%% Orthogonalization and normalization
if abs(s_sig_g)>0
    H = [];
    if ortho == 1 
        H = [ones(T,1)];
    elseif ortho == 2 
        H = [ones(T,1) s_F];
    end
    
    if size(H,1)>0
        % orthogonalization
        H   = H(:,abs(sum(H,1))>0);
        M   = eye(T) - H*inv(H'*H)*H'; % annihilator = (I - orthogonal projection matrix)
        s_G = M*s_G;
    
        % variance & std of \phi_g
        vv = var_ar(s_phi_g,1);
        sd = sqrt(vv(1,1));
    
        s_sig_g = s_sig_g*sqrt(var(s_G))/sd;
        s_G     = s_G/sqrt(var(s_G))*sd;
    end
end

end

