function [ s_F, s_sig_f ] = states_F(y, s_G,...
                                s_phi_f, s_phi_mu,...
                                s_sig_g, s_sig_f, s_sig_mu,...
                                s_gam_g, s_gam_f,...
                                ind_f, lags, ortho)
%states_F Samples the global financial and global macro factor using FFBS
%   Forward-filter backward sampler for global variable-specific factors
[T,I] = size(y);
Fnr = max(ind_f);
N = I/max(ind_f);
%% Transforming data series
%   purge other factor information from series to get y*
%   to cast model into state-space form, need to handle AR-process in \mu_t
%   following Chib and Greenberg (1994) -> y_tilde
y_tilde = zeros(T,I);
ystar   = zeros(T,I);

for i=1:I
   ystar(:,i) = y(:,i) - s_gam_g(i,1)*s_sig_g*s_G;
   y_tilde(:,i) = trans_ar(ystar(:,i),s_phi_mu(i,:));
end
%% Sampling variable-specific factors by FFBS
s_F = zeros(T,Fnr);
%   set up state space matrices
%   Yt = Zt*St   + Vt ,    Vt~N(0,Ht)
%   St = Tt*St-1 + Kt*Et , Et~N(0,Qt)
Kt = zeros(lags+1,1,T); Kt(1,1,:) = 1; 
Tt = zeros(lags+1,lags+1); Tt(2:end,1:end-1) = eye(lags);

%**************************************************************************
% loop for sequential sampling of F^m and F^f
factor_order = [2,1];
for ii = 1: Fnr
    f = factor_order(ii);
    y_tilde_f  = y_tilde(:,ind_f==f); Na = size(y_tilde_f,2);
    s_gam_ff   = s_gam_f(ind_f==f,1);
    s_sig_mu_f = s_sig_mu(ind_f==f,1);
    s_phi_i_f  = s_phi_mu(ind_f==f,:);
    
    Zt      = zeros(Na,lags+1,T);
    Ht      = zeros(Na,Na,T);
    Tt(1,:) = [s_phi_f(f,:) 0];
    
    S0 = zeros(lags+1,1);
    Qt = 1; % normalize variance of innovations to 1
    
    %   initialize var-cov matrix of states
    Q1 = zeros((lags+1)^2,1); Q1(1,1) = Qt;
    P1 = inv((eye((lags+1)^2)-kron(Tt,Tt)))*Q1;
    P0 = reshape(P1',lags+1,lags+1);
    
    for j = 1:Na
        Zt(j,1,:) = s_gam_ff(j,1)*s_sig_f(f,1);
        for a = 1:lags
            Zt(j,a+1,:) = -s_phi_i_f(j,a)*s_gam_ff(j,1)*s_sig_f(f,1);
        end
        Ht(j,j,:) = s_sig_mu_f(j,1)^2;
    end
    % -------------------------------------------------------------------------
    %   Run Kalman filter forward and sampler backward
    %   Draw sample s_F
    % -------------------------------------------------------------------------
    [hStt,hPtt] = Kalman_filter_um(y_tilde_f, Zt, [], S0, P0, Qt, Tt, Kt, Ht, []);
    draws       = Kalman_sampler_um(hStt,hPtt,Tt,Qt,Kt(:,:,1));
    s_F(:,f)    = draws(1,:)';

    %% Orthogonalization and normalization
    if abs(s_sig_f(f,1))>0
        s_Fn = s_F; s_Fn(:,f) = [];
        if ortho == 1 
            H = [ones(T,1) s_Fn];
        elseif ortho == 2 
            H = [ones(T,1) s_G s_Fn];
        end
        
        if ortho > 0
            H = H(:,abs(sum(H,1))>0);
            M = eye(T) - H*inv(H'*H)*H'; %  annihilator = (I - orthogonal projection matrix)
            
            s_F(:,f) = M*s_F(:,f);
            
            vv = var_ar(s_phi_f(f,:),1);
            sd = sqrt(vv(1,1));
            
            s_sig_f(f,1) = s_sig_f(f,1)*sqrt(var(s_F(:,f)))/sd;
            s_F(:,f)     = s_F(:,f)/sqrt(var(s_F(:,f)))*sd;
        end
    end
end
%**************************************************************************

end

