% Time Series Plots with Shaded Recessions 
% obtained from: Camilo Marchesini,
% https://forum.dynare.org/t/manually-adding-recession-bars-with-matlab/14597/2

Recessions=[1997.5, 1999.0; % Asia Crisis
    2001.0, 2001.75;        % Dotcom Crash
    2007.75, 2009+1/4       % GFC
    2011.75, 2012.5];        % EA Debt Crisis

 
xlimits=get(gca,'XLim'); % Get axis. 

min_idx=min(find(Recessions(:,1)-xlimits(1)>=0));

Recessions=Recessions(min_idx:end,:);

if  Recessions(1,1)<xlimits(1)
    Recessions(1,1)=xlimits(1);
end


if  Recessions(end,end)>xlimits(2)
    Recessions(end,end)=xlimits(2);
end


