% Time Series Plots with Shaded Recessions 
% obtained from: Camilo Marchesini,
% https://forum.dynare.org/t/manually-adding-recession-bars-with-matlab/14597/2

recession_dates

ylimits=get(gca,'YLim'); % Get axis.
ylimits(1) = ylimits(1) + 0.01*abs(ylimits(1));
ylimits(2) = ylimits(2) - 0.01*abs(ylimits(2));
 
% Put recessions dates as bars.
for iiii=1:1:size(Recessions,1)

    % Full grey area, without edges.
    patch([Recessions(iiii,1),Recessions(iiii,2),Recessions(iiii,2),Recessions(iiii,1)]',...
        [ylimits(1) ylimits(1) ylimits(2) ylimits(2)]',[0.95 0.95 0.95],'EdgeColor','none'); hold on
    
    % Edges at bottom.
    patch([Recessions(iiii,1),Recessions(iiii,2),Recessions(iiii,2),Recessions(iiii,1)]',...
        [ylimits(1) ylimits(1) ylimits(1) ylimits(1)]',[0.95 0.95 0.95],'EdgeColor','none'); hold on
    
    % Edges at top.
    patch([Recessions(iiii,1),Recessions(iiii,2),Recessions(iiii,2),Recessions(iiii,1)]',...
        [ylimits(2) ylimits(2) ylimits(2) ylimits(2)]',[0.95 0.95 0.95],'EdgeColor','none'); hold on
    
    
    % Edges left if first recession date is equal to initial date. 
    if Recessions(1)<=xlimits(1) && iiii==1
    patch([xlimits(1),xlimits(1),xlimits(1),xlimits(1)]',...
        [ylimits(1) ylimits(1) ylimits(2) ylimits(2)]',[0.95 0.95 0.95],'EdgeColor','none'); hold on
    end
    

    % Edges right if last recession date is equal to final date.
    if Recessions(end)>=xlimits(2) && iiii==size(Recessions,1)
    patch([xlimits(2),xlimits(2),xlimits(2),xlimits(2)]',...
        [ylimits(1) ylimits(1) ylimits(2) ylimits(2)]',[0.95 0.95 0.95],'EdgeColor','none'); hold on
    end
    
    
end


 