function [s_sig_g,s_sig_f,s_delta, s_p_delta] = para_stdv(y,s_G,s_F,...
                                                       s_phi_mu,s_sig_mu,...
                                                       a0_std_fac,A0_std_fac,...
                                                       s_gam_g,s_gam_f,...
                                                       ind_f,s_indic,...
                                                       p0,s_delta,...
                                                       model_exp)
%para_stdv Samples binary indicator and standard deviation
    %   Detailed explanation goes here
% -------------------------------------------------------------------------
% INPUTS:
% y                            - dependent variables
% s_G, s_F                     - regressors (i.e. common factors)
% s_phi_mu, s_sig_mu           - AR coefficient and variance of idiosyncr component
% a0_std_fac, A0_std_fac       - Priors for std of factors (i.e. prior for beta in Bayes regr)
% s_gam_g, s_gam_f             - loadings of common factors
% ind_f                        - indicators for variable- and country-specific series
% s_indic                      - switches binary indicator selection "on" (=1) and "off" (=0)
% p0                           - Bernoulli prior distribution of binary indicators
% s_delta                      - binary indicators
% model_exp                    - choice which factors to excl=0, incl=1, sample indicator=2
   %                             gives vector of factor settings 
% -------------------------------------------------------------------------
% OUPUTS:
% s_sig_g, s_sig_f             - sampled standard deviation of common factors
% s_delta                      - sampled binary indicators
% s_p_delta                    - sampled posterior factor inclusion probability
%% Get dimensions
[T,I] = size(y);
Fnr   = max(ind_f);

%% Transforming series
yy = []; GG = []; FF = [];
for i = 1:I
    y_tilde = trans_ar(y(:,i),s_phi_mu(i,:));
    yy      = [yy; y_tilde/s_sig_mu(i,1)];
    
    G_tilde = trans_ar(s_G,s_phi_mu(i,:));
    GG      = [GG;s_gam_g(i,1)*G_tilde/s_sig_mu(i,1)];
    
    F_tilde = zeros(T,Fnr);
    F_tilde(:,ind_f(1,i)) = s_gam_f(i,1)*trans_ar(s_F(:,ind_f(1,i)),s_phi_mu(i,1))/s_sig_mu(i,1);
    FF      = [FF;F_tilde];
    
end
XX = [GG FF]; % Matrix of regressors

%% Sampling binary indicators
s_p_delta = s_delta*NaN;
for f = 1:size(s_delta,2)
   if s_indic == 1 
       if model_exp(1,f)>0
           index = s_delta;
           
           log_ml = zeros(1,2); log_post_delta = zeros(1,2);
           
           % calculate marginal likelihood for delta=0
           index(1,f) = 0;
           log_ml(1,1) = Bayesian_regression(yy,XX(:,index==1),...
                                            a0_std_fac*ones(sum(index),1),A0_std_fac*eye(sum(index)),...
                                            [],[],1);
           % calculate posterior model log probability 
           log_post_delta(1,1) = log_ml(1,1) + log(1-p0); 
           
           % calculate marginal likelihood for delta=1
           index(1,f) = 1;
           log_ml(1,2) = Bayesian_regression(yy,XX(:,index==1),...
                                            a0_std_fac*ones(sum(index),1),A0_std_fac*eye(sum(index)),...
                                            [],[],1);
           % calculate posterior model log probability 
           log_post_delta(1,2) = log_ml(1,2) + log(p0);
           
           e = exp(log_post_delta- max(log_post_delta));
           
           s_p_delta(1,f) = e(1,2)/sum(e);
           
           if model_exp(1,f) == 2
               % draw model from posterior model probability
               s_delta(1,f) = binornd(1,s_p_delta(1,f));
           end
       end
   end
end

%% Sampling standard deviations of common factors
% model was transformed such that it has linear regression model structure
% and std of factors are now just regression coeff (i.e. b) for \tilde{factors}
% Hence we draw b from the posterior normal distribution p(b1,B1)
b_draw0 = zeros(1+Fnr,1);
if sum(s_delta)>0
    b_draw = N_post(yy,XX(:,s_delta==1),...
                   a0_std_fac*ones(sum(s_delta),1),A0_std_fac*eye(sum(s_delta)),1);
    b_draw0(s_delta==1,1) = b_draw;  
end
s_sig_g = b_draw0(1,1);
s_sig_f = b_draw0(2:1+Fnr,1);

end

