function  graphs(T,I,N,Fnr,ind_f,data,results,sim,model) 
draws = size(results.sig_g.alldraws,2);


%% Global factor
if model(1,1)>0
    figure;
    subplot(4,1,1);
    if sim==1
        confplot(1:1:T,[data.G results.G.mean],results.G.perc5,results.G.perc95)
    else
        confplot(1:1:T,results.G.mean,results.G.perc5,results.G.perc95)
    end
    xlim([1 T]); title('common factor G');

    subplot(4,1,2);
    histogram(results.sig_g.alldraws,100)
    title('Stdv common factor G');

    subplot(4,1,3);
    plot(1:1:draws,abs(results.sig_g.alldraws))
    xlim([1 draws]);
    title('Stdv common factor G');
    
    subplot(4,1,4);
    if sim==1
        confplot(1:1:I,[data.gam_g results.gam_g.mean],results.gam_g.perc5,results.gam_g.perc95)
    else
        confplot(1:1:I,results.gam_g.mean,results.gam_g.perc5,results.gam_g.perc95)
    end
    xlim([1 I]); title('Loadings to common factor G');
end

%% Varibale-specfic factors
if model(1,2)>0
    figure;
    for f=1:Fnr
        subplot(Fnr,4,1+(f-1)*4);
        if sim==1
            confplot(1:1:T,[data.F(:,f) results.F.mean(:,f)],results.F.perc5(:,f),results.F.perc95(:,f))
        else
            confplot(1:1:T,results.F.mean(:,f),results.F.perc5(:,f),results.F.perc95(:,f))
        end
        xlim([1 T]); title(['group factor F',int2str(f)]);

        subplot(Fnr,4,2+(f-1)*4);
        histogram(results.sig_f.alldraws(f,:),100)
        title(['Stdv group factor F',int2str(f)]);

        subplot(Fnr,4,3+(f-1)*4);
        plot(1:1:draws,abs(results.sig_f.alldraws(f,:)))
        xlim([1 draws]);
        title(['Stdv group factor F',int2str(f)]);
        
        subplot(Fnr,4,4+(f-1)*4);
        if sim==1
            confplot(1:1:size(ind_f(ind_f==f),2),[data.gam_f(ind_f==f) results.gam_f.mean(ind_f==f)],results.gam_f.perc5(ind_f==f),results.gam_f.perc95(ind_f==f))
        else
            confplot(1:1:size(ind_f(ind_f==f),2),results.gam_f.mean(ind_f==f),results.gam_f.perc5(ind_f==f),results.gam_f.perc95(ind_f==f))
        end
        xlim([1 size(ind_f(ind_f==f),2)]); title(['Loadings to group factor F',int2str(f)]);
    end
end

end

