function [b_draw,b_star] = N_post(y,X,a0,A0,var)
%N_post Draws a sample for beta from the posterior normal distribution in
%Bayesian regression model
%   Code from Tino Berger (Uni Gttingen)
% -------------------------------------------------------------------------
% INPUTS:
% y                            - dependent variables
% x                            - regressors (i.e. common factors)
% a0, A0                       - Priors for std of factors (i.e. prior for beta in Bayes regr)
% var                          - error variance
% -------------------------------------------------------------------------
% OUPUTS:
% b_draw                       - posterior draw for beta
% b_star                       - sampled binary indicators
% -------------------------------------------------------------------------
% Estimated parameters (OLS)
M      = X'*X;
b      = inv(M)*X'*y;
% Prior parameters
b_0    = a0;
M_0    = inv(A0);
% Posterior parameters
M_star = M_0 + M;
A_T    = inv(M_star);
b_star = A_T*(M_0*b_0 + M*b);
% Take draw from posterior distribution
var_b  = A_T*var;
b_draw = mvnrnd(b_star,var_b,1)';

end

