function [b_draw,var_eps_draw] = NIG_post(y,x,a0,A0,c0,C0)
%NIG_post Draws sample for beta and variance from Normal Inverse Gamma
%posterior dirstribution (Bayesian regression with natural conjugate prior)
% -------------------------------------------------------------------------
% INPUTS:
% y                            - dependent variables
% x                            - regressors (i.e. common factors)
% a0_lambda,A0_lambda          - Normal Priors for loadings of factors (i.e. prior for beta in Bayes regr)
% c0,C0                        - IG Priors for observation error variance
% -------------------------------------------------------------------------
% OUPUTS:
% b_draw                       - draw of regression coefficients beta
% var_draw                     - draw of error variance
%% Get dimensions
[T,k] = size(y);
%% Posterior parameters
AT = inv(x'*x + inv(A0));
aT = AT*(x'*y + inv(A0)*a0);
cT = c0 + T/2;
CT = C0 + 0.5*(y'*y + a0'*inv(A0)*a0 - aT'*inv(AT)*aT);
%% Drawing variance from Inverse Gamma posterior distribution
%  var ~ IG
var_eps_draw = 1./gamrnd(cT,1/CT);
%% Drawing regression coefficients from Normal conditional on variance
%  beta|var ~ N
var_b = AT*var_eps_draw;
b_draw = aT + (randn(1,size(aT,1))*chol(var_b))';

end

