function draw_state = Kalman_sampler_um( Att, Ptt, C, Q, R )
% Based on the results of the kalman filter (Att and Ptt) this function can
% take draws from the state wich are conditional on each other. The
% structure of the state equation is: at+1 = C*at + R*eta ~ 
% N(0,Q(m,m)) where Q(n,n) is the variance matrix of the error terms.

T = size(Att,2);
m = size(C,1);
draw_state = zeros(m,T);
[U,S,V] = svd(Ptt(:,:,T));
O = (U*sqrt(S))';
RQR = R*Q*R';

draw_state(:,T) = Att(:,T) + (randn(1,m)*O)';
try
    for t=T-1:-1:1
        Ft = C*Ptt(:,:,t)*C' + RQR;
        vt = draw_state(:,t+1) - (C*Att(:,t));
        Kt = Ptt(:,:,t)*C'/Ft;
        Astar = Att(:,t) + Kt*vt;
        Pstar = Ptt(:,:,t) - Kt*C*Ptt(:,:,t);

        [O,p] = chol(Pstar);
        
        if p == 0
            draw_state(:,t) = Astar + (randn(1,m)*O)'; 
        else
            [U,S,V] = svd(Pstar);
            O       = (U*sqrt(S))';
            draw_state(:,t) = Astar + (randn(1,m)*O)';
        end
    end
catch
    for t=T-1:-1:1
        Ft = C(:,:,t)*Ptt(:,:,t)*C(:,:,t)' + RQR;
        vt = draw_state(:,t+1) - (C(:,:,t)*Att(:,t));
        Kt = Ptt(:,:,t)*C(:,:,t)'/Ft;
        Astar = Att(:,t) + Kt*vt;
        Pstar = Ptt(:,:,t) - Kt*C(:,:,t)*Ptt(:,:,t);

        [O,p] = chol(Pstar);

        if p == 0
            draw_state(:,t) = Astar + (randn(1,m)*O)'; 
        else
            [U,S,V] = svd(Pstar);
            O       = (U*sqrt(S))';
            draw_state(:,t) = Astar + (randn(1,m)*O)';
        end
    end    
end
end
