# GP vs GPAD table
gp_vs_gpad_table <- function(xs) {
    tbl <- rbind(
        c(sapply(xs, \(x) x$mse_gp), xs[[1]]$mse_gpad),
        c(sapply(xs, \(x) x$time_gp$toc - x$time_gp$tic),
          xs[[1]]$time_gpad$toc - xs[[1]]$time_gpad$tic)
    )
    rownames(tbl) <- c("MSE", "Time")
    colnames(tbl) <- c(100, 500, 1e3, 2e3, 4e3, "GP+AD (100)")
    tbl
}

scale <- function(x, i, factor) {
    x[i, ] <- factor * x[i, ]
    rownames(x)[i] <- paste0(rownames(x)[i], " (x", factor, ")")
    x
}

suffix <- function(x, i, char, ...) {
    x[i, ] <- paste(x[i, ], char, ...)
    x
}

decimal <- function(x, i, places) {
    x[i, ] <- round(x[i, ], places)
    x
}


# Generate LaTeX tables
tmp <- readRDS("output/GP_vs_GPAD_p_30_12345.RDS")
print(gp_vs_gpad_table(tmp))
gp_vs_gpad_table(tmp) |>
    scale(1, 10^7) |>
    decimal(1, places = 2) |>
    decimal(2, places = 2) |>
    suffix(2, "s", sep = "") |>
    xtable::xtable()

# Check prediction dimension by dimension
cbind(
    tmp[[1]]$testing$y_truth |> colMeans(),
    tmp[[1]]$testing$y_gp |> colMeans(),
    tmp[[1]]$testing$y_gpad |> colMeans()
) |>
    round(3)
