`%+%` <- paste0

writeToFile <- function(x, file, ...) {
    saveRDS(x, file = gsub(file, pattern = ".txt", replacement = ".rds", fixed = T))
    writeLines(capture.output(x), file, ...)
    return(x)
}

corr_plot <- function(x) {
    function(...) {
        corrplot::corrplot(x, is.corr = FALSE, ...)
    }
}

set_lapply <- function(parallel = FALSE, mc.cores = 4, ...) {
    if (!parallel) return(lapply)
    return(purrr::partial(parallel::mclapply, mc.cores = mc.cores, ...))
}
