domain_table <- function(expert_priors, domain_bound, parameter_names) {
    bounds <- t(get_high_sensitivity_region(domain_bound,
                                            parameter_names))
    parameter_index <- colnames_to_index(parameter_names)
    baseline <- sapply(parameter_index, function(ind) {
        ifelse(ind <= 18,
               expert_priors$PriorMean[ind],
               log(diag(expert_priors$PriorCov)[ind - 18]))
    })
    cbind(LB = bounds[,1], Expert = baseline, UB = bounds[,2])
}

# # Testing
# priors <- tar_read(priors)
# trajectory_domain_bound <- tar_read(trajectory_domain_bound)
# influential_input_aggregate_location <- tar_read(influential_input_aggregate_location)
# influential_input_aggregate_precision <- tar_read(influential_input_aggregate_precision)
# domain_table(priors,
#              trajectory_domain_bound,
#              influential_input_aggregate_location) |>
#     round(3)
# domain_table(priors,
#              trajectory_domain_bound,
#              influential_input_aggregate_precision) |>
#     round(3)
