plot_spectrum <- function(bayes_CE_GP,
                          bayes_EE_GP,
                          freq_cross_elast,
                          freq_exp_elast,
                          priors_cross_elast,
                          priors_exp_elast,
                          suffix,
                          xlab = "Confidence on expert prior information",
                          main_prior = "Prior specification",
                          alter_prior = "Frequentist estimates",
                          mar = c(6.1, 6.1, 4.1, 2.1),
                          title_ylab_line = 4,
                          legend_x = c(0.075, 0.1),
                          legend_y = c(0.85, 0.85)) {
    # CE own price + EE (4 x 2)
    png(output(paste0("figures/EE_scenario_spectrum_", suffix, ".png")),
        width = 1000, height = 1200)
    layout.matrix <- matrix(c(1:4, 9, 5:8, 9), nrow = 5, ncol = 2)
    graphics::layout(
        mat = layout.matrix,
        heights = c(1, 1, 1, 1, 0.3), # Heights of the two rows
        widths = c(1, 1)
    ) # Widths of the two columns
    par(las = 1, cex.lab = 2, cex.main = 2, cex.axis=1.5, mar = mar)
    s <- seq(0.1, 0.9, 0.02)
    for (i in 1:4) {
        # Expenditure elasticities
        plot_gp(s, bayes_EE_GP[[i]]$model,
                main = paste0("Expenditure elasticity of food group ", i),
                xlab = xlab, ylab = "")
        # Reference lines
        abline(h = c(-1, 0, 1), lty = 2)
        abline(h = freq_exp_elast[i], col = "green", lwd = 2)
        abline(h = priors_exp_elast[i], col = "darkolivegreen4", lwd = 2)
        title(ylab = "Expenditure elasticity", line = title_ylab_line, cex.lab = 2)
    }
    for (i in 1:4) {
        # Own-price elasticities
        plot_gp(s, bayes_CE_GP[[i]][[i]]$model,
                main = paste0("Own-price elasticity of food group ", i),
                xlab = xlab,
                ylab = "")
        abline(h = c(-1, 0, 1), lty = 2)
        abline(h = freq_cross_elast[i, i], col = "green", lwd = 2)
        abline(h = priors_cross_elast[i, i], col = "darkolivegreen4", lwd = 2)
        title(ylab = "Own-price elasticity", line = title_ylab_line, cex.lab = 2)
    }
    # Legend
    par(mar = c(0, 0, 0, 0))
    plot.new()
    legend(legend_x[1], legend_y[1],
           ncol = 4,
           inset = c(0.0, 0.0),
           legend = c("Posterior manifold",
                      "Bayesian estimates",
                      main_prior,
                      alter_prior),
           lty = c(1, NA, 1, 1),
           lwd = c(1, NA, 2, 2),
           col = c("black", "black", "darkolivegreen4", "green"),
           cex = 2,
           pch = c(NA, 19, NA, NA),
           xpd = NA)
    dev.off()


    # CE cross price (3 x 3: 12,13,14,23,24,34; 21,31,41,32,42,43;)
    png(output(paste0("figures/CE_scenario_spectrum_", suffix, ".png")),
        width = 1100, height = 1200)
    layout.matrix <- matrix(c(1:12, rep(13, 3)), nrow = 5, ncol = 3, byrow = TRUE)
    graphics::layout(
        mat = layout.matrix,
        heights = c(1, 1, 1, 1, 0.3), # Heights of the two rows
        widths = c(1, 1, 1)
    ) # Widths of the two columns
    par(las = 1, cex.lab = 2, cex.main = 2, cex.axis=1.5, mar = mar)
    s <- seq(0.1, 0.9, 0.02)
    for (i in 1:4) {
        for (j in 1:4) {
            if (i != j) {
                plot_gp(s, bayes_CE_GP[[i]][[j]]$model,
                        main = paste0("Cross-price elasticity of \nfood group ", i,
                                      " wrt food group ", j),
                        xlab = xlab, ylab = "")
                abline(h = c(-1, 0, 1), lty = 2)
                abline(h = freq_cross_elast[i, j], col = "green", lwd = 2)
                abline(h = priors_cross_elast[i, j], col = "darkolivegreen4", lwd = 2)
                title(ylab = "Cross-price elasticity", line = title_ylab_line, cex.lab = 2)
            }
        }
    }
    # Legend
    par(mar = c(0, 0, 0, 0))
    plot.new()
    legend(legend_x[2], legend_y[2],
           ncol = 4,
           inset = c(0.0, 0.0),
           legend = c("Posterior manifold",
                      "Bayesian estimates",
                      main_prior,
                      alter_prior),
           lty = c(1, NA, 1, 1),
           lwd = c(1, NA, 2, 2),
           col = c("black", "black", "darkolivegreen4", "green"),
           cex = 2,
           pch = c(NA, 19, NA, NA),
           xpd = NA)
    dev.off()
}
