plot_gp <- function(x, model, predict_fun = predict_gp, ...) {
    plot(model$train_X, model$train_y,
         ylim = extendrange(model$train_y, f = 0.1),
         type = 'n', ...)
    plot_confidence_band(x, model, predict_fun, col = 'lightgray')
    plot_predictive_mean(x, model, predict_fun)
    plot_training_points(model)
}

plot_confidence_band <- function(x, model, predict_fun = predict_gp, ...) {
    prediction <- predict_fun(model, as.matrix(x))
    p_mean <- prediction$mean
    p_sd <- sqrt(abs(diag(prediction$covariance)))
    polygon(c(x, rev(x)),
            c(p_mean - 2 * p_sd, rev(p_mean + 2 * p_sd)),
            border = NA, ...)
}

plot_predictive_mean <- function(x, model, predict_fun = predict_gp, ...) {
    prediction <- predict_fun(model, as.matrix(x))
    p_mean <- prediction$mean
    lines(x, p_mean, ...)
}

plot_training_points <- function(model, ...) {
    points(model$train_X, model$train_y, pch = 19, ...)
}
