plot_ce_baseline_estimates <- function(bayes_cross_elast,
                                       freq_cross_elast,
                                       zero_bayes_cross_elast) {
    get_mean <- \(x) if ("mean" %in% names(x)) x$mean else x
    ce <- \(x) as.numeric(t(get_mean(x))[1:4,1:4])
    ee <- \(x) as.numeric(get_mean(x)[1:4])

    png(output("figures/baseline_estimates_ce.png"), height = 648, width = 1200,
        pointsize = 16)
    par(mfrow = c(1,1))
    par(las = 1, family = "DejaVu Sans", mar = c(8.1, 5.1, 4.1, 2.1))
    text_size <- 1.5
    plot(1:16,
         ce(bayes_cross_elast),
         type = "n",
         xaxt = "n",
         main = "Bayesian and frequentist estimates of price elasticities",
         xlab = "Food group pairs",
         ylab = "",
         cex.lab = text_size,
         cex.axis = text_size,
         cex.main = text_size * 1.2,
         cex.sub = text_size,
         ylim = c(-1.1, 0.1))
    # Plot region color
    rect(par("usr")[1], par("usr")[3],
         par("usr")[2], par("usr")[4],
         col = "#eeeeee")
    abline(v = 1:16, h = seq(-1, 0, 0.2), col = "white", lwd = 2)
    abline(h = c(0, 1, -1), lty = 2)
    points(1:16,
           ce(bayes_cross_elast),
           cex = 1.5,
           pch = 19)
    points(1:16,
           ce(zero_bayes_cross_elast),
           pch = 1,
           cex = 2)
    points(1:16,
           ce(freq_cross_elast),
           pch = 4,
           cex = 1.5)
    y_ticks <- apply(expand.grid(1:4,1:4)[, 2:1],
                     MARGIN = 1,
                     function(x) paste0(x, collapse = ","))
    axis(side = 1, at = 1:16, labels = y_ticks, cex.axis = text_size)
    title(ylab = "Price elasticities", line = 3.5, cex.lab = text_size)
    legend("topright",
           inset=c(0.0, 1.1),
           legend=c("Bayesian estimates with expert prior",
                    "Bayesian estimates with non-informative prior",
                    "Frequentist estimates"),
           pch=c(19, 1, 4), xpd = TRUE)
    dev.off()
}


plot_ee_baseline_estimates <- function(bayes_exp_elast,
                                       freq_exp_elast,
                                       zero_bayes_exp_elast) {
    get_mean <- \(x) if ("mean" %in% names(x)) x$mean else x
    ce <- \(x) as.numeric(t(get_mean(x))[1:4,1:4])
    ee <- \(x) as.numeric(get_mean(x)[1:4])

    png(output("figures/baseline_estimates_ee.png"), height = 648, width = 1200,
        pointsize = 16)
    par(mfrow = c(1,1))
    par(las = 1, family = "DejaVu Sans", mar = c(8.1, 5.1, 4.1, 2.1))
    text_size <- 1.5
    plot(1:4,
         ee(bayes_exp_elast),
         type = "n",
         xaxt = "n",
         main = "Bayesian and frequentist estimates of expenditure elasticities",
         xlab = "Food groups",
         ylab = "",
         cex.lab = text_size,
         cex.axis = text_size,
         cex.main = text_size * 1.2,
         cex.sub = text_size,
         ylim = c(0.8, 1.2),
         xlim = c(0.5, 4.5))
    # Plot region color
    rect(par("usr")[1], par("usr")[3],
         par("usr")[2], par("usr")[4],
         col = "#eeeeee")
    abline(v = 1:4, h = seq(0, 2, 0.1), col = "white", lwd = 2)
    abline(h = c(0, 1, -1), lty = 2)
    points(1:4,
           ee(bayes_exp_elast),
           cex = 1.5,
           pch = 19)
    points(1:4,
           ee(zero_bayes_exp_elast),
           pch = 1,
           cex = 2)
    points(1:4,
           ee(freq_exp_elast),
           pch = 4,
           cex = 1.5)
    axis(side = 1, at = 1:4, labels = 1:4, cex.axis = text_size)
    title(ylab = "Price elasticities", line = 3.5, cex.lab = text_size)
    legend("topright",
           inset=c(0.0, 1.1),
           legend=c("Bayesian estimates with expert prior",
                    "Bayesian estimates with non-informative prior",
                    "Frequentist estimates"),
           pch=c(19, 1, 4), xpd = TRUE)
    dev.off()
}
