estimate_EE_manifolds_on_weights <- function(weights, bayes_EE) {
    food_group_ids <- 1:5
    food_group_ids %>%
        map(function(id) {
            y <- map_dbl(bayes_EE, ~.x$mean[id])
            y_sd <- map_dbl(bayes_EE, ~.x$se[id])
            estimate_manifold_on_weights(weights, y, sigma = y_sd)
        })
}


estimate_CE_manifolds_on_weights <- function(weights, bayes_CE) {
    food_groups_ids <- 1:5
    food_groups_ids %>%
        map(function(i) {
            food_groups_ids %>%
                map(function(j) {
                    y <- map_dbl(bayes_CE, ~.x$mean[i, j])
                    y_sd <- map_dbl(bayes_CE, ~.x$se[i, j])
                    estimate_manifold_on_weights(weights, y, sigma = y_sd)
                })
        })
}


#' Estimate the manifold over the confidence weights
#'
#' @param x A numeric vector; the confidence weights.
#' @param y A numeric vector; the price elasticities.
#' @param ... Optional parameters to pass to `gptools2::gp`.
estimate_manifold_on_weights <- function(x, y, ...) {
    model <- gp(X = as.matrix(x), y = y, ...)
    new_x <- as.matrix(seq(min(x), max(x), length.out = 50))
    list(model = model,
         newdata = new_x,
         pred = predict_gp(model, new_x))
}
