#' Estimate the SUR model using the frequentist approach and
#' specifically the Virtual-Supermarket data
#' @param data A data frame; the VS data.
#' @export
frequentist_estimate <- function(data) {
    # 1) System
    eq1 <- w1 ~ lnp1P5 + lnp2P5 + lnp3P5 + lnp4P5 + lnXR
    eq2 <- w2 ~ lnp1P5 + lnp2P5 + lnp3P5 + lnp4P5 + lnXR
    eq3 <- w3 ~ lnp1P5 + lnp2P5 + lnp3P5 + lnp4P5 + lnXR
    eq4 <- w4 ~ lnp1P5 + lnp2P5 + lnp3P5 + lnp4P5 + lnXR
    # 2) Restrictions
    Rmat <- matrix(0, nrow = 6, ncol = 24)
    Rmat[1, 3] <- 1
    Rmat[1, 8] <- -1
    Rmat[2, 4] <- 1
    Rmat[2, 14] <- -1
    Rmat[3, 5] <- 1
    Rmat[3, 20] <- -1
    Rmat[4, 10] <- 1
    Rmat[4, 15] <- -1
    Rmat[5, 11] <- 1
    Rmat[5, 21] <- -1
    Rmat[6, 17] <- 1
    Rmat[6, 22] <- -1
    rvec <- rep(0, 6)
    # 3) Estimation
    eqSystem <- list(eq1 = eq1, eq2 = eq2, eq3 = eq3, eq4 = eq4)
    systemfit::systemfit(
        eqSystem, method = "SUR", data = data,
        restrict.matrix = Rmat, restrict.rhs = rvec
    )
}


#' Tidying the results from the frequentist estimation
#' @param freq_res A object returned by `frequentist_estimate`.
#' @keywords internal
tidy_freq_est <- function(freq_res) {
    freq_res$coefficients %>%
        magrittr::extract(c(
            "eq1_(Intercept)", "eq2_(Intercept)", "eq3_(Intercept)", "eq4_(Intercept)",
            "eq1_lnp1P5", "eq1_lnp2P5", "eq1_lnp3P5", "eq1_lnp4P5",
            "eq2_lnp2P5", "eq2_lnp3P5", "eq2_lnp4P5",
            "eq3_lnp3P5", "eq3_lnp4P5",
            "eq4_lnp4P5",
            "eq1_lnXR", "eq2_lnXR", "eq3_lnXR", "eq4_lnXR"
        )) %>%
        rename()
}


#' Rename an object according to the LAID model
#' @param x A vector; the object to be renamed.
#' @param prefix Prefix to add to the column name.
#' @param suffix Suffix to add to the column name.
#' @keywords internal
rename <- function(x, prefix = "", suffix = "") {
    df_name <- c("a_1", "a_2", "a_3", "a_4", "g_11", "g_12", "g_13", "g_14", "g_22",
                 "g_23", "g_24", "g_33", "g_34", "g_44", "b_1", "b_2", "b_3", "b_4")
    structure(
        data.frame(t(as.numeric(x))),
        names = paste0(prefix, df_name, suffix)
    )
}
