testthat::test_that(
    "Kernel covariance matrix for derivative (Rcpp VS R)", {
    set.seed(1234)
    for (i in 1:100) {
        X1 <- matrix(rnorm(10), 5, 2)
        X2 <- matrix(rnorm(6), 3, 2)
        k <- squared_exponential()
        D1 <- kcov(X1, X2, k$kern_fun(2, 0.5))
        
        kd <- squared_exponential_d()
        D2 <- kcov_d(X1, X2, kd$kern_fun(2, 0.5))
        testthat::expect_lt(max(abs(D1 - D2)), 1e-8)
        
        D <- D1
        dK_dX2_R <- kcov_d(X1, X2, kd$dk_dx2(2, 0.5))
        dK_dX2_Rcpp <- kcov_se_df_dx2(X1, X2, D, 0.5^2)
        testthat::expect_lt(max(abs(dK_dX2_R - dK_dX2_Rcpp)), 1e-8)
    
        d2K_dX1_dX2_R <- kcov_d(X1, X2, kd$dk2_dx1_dx2(2, 0.5))
        d2K_dX1_dX2_Rcpp <- kcov_se_d2f_dx1_dx2(X1, X2, D, 0.5^2)
        testthat::expect_lt(max(abs(d2K_dX1_dX2_R - d2K_dX1_dX2_Rcpp)), 1e-8)
    }
})
