% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate_gp.R
\name{mgp}
\alias{mgp}
\title{Multivariate Gaussian Process}
\usage{
mgp(X, Y, kernel = squared_exponential(), Sigma, ...)
}
\arguments{
\item{X}{A numeric matrix; the data.}

\item{Y}{A numeric matrix; the data.}

\item{kernel}{A kernel object, which is a named list of a list of
named parameters and an uninitialised kernel function.}

\item{Sigma}{A numeric matrix; the covariance of the noise of the data.
The dimension of `Sigma` should be equal to the dimension of `Y`.}

\item{...}{Optional argument to pass to \code{optim}.}
}
\description{
Multivariate Gaussian Process
}
\examples{
\dontrun{
X <- matrix(10 * runif(300), ncol = 3)
f <- function(X) {
  Y <- matrix(0, nrow = nrow(X), ncol = 2)
  Y[,1] <- sin(X[,1] + X[,2]) + 2 * X[,3]
  Y[,2] <- cos(X[,1] - X[,3]) + X[,2]
  Y
}
Y <- f(X)

model <- mgp(X, Y, Sigma = diag(2))
fitted_Y <- predict_mgp(model, X)$mean
head(cbind(Y, fitted_Y))
compare(as.numeric(Y), as.numeric(fitted_Y))

new_X <- matrix(10 * runif(90), ncol = 3)
new_Y <- f(new_X)
fitted_new_Y <- predict_mgp(model, new_X)$mean
head(cbind(new_Y, fitted_new_Y))
compare(as.numeric(new_Y), as.numeric(fitted_new_Y))
}

}
