% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active_learning.R
\name{gp_surrogate}
\alias{gp_surrogate}
\title{Gaussian Process surrogate function}
\description{
Gaussian Process surrogate function

Gaussian Process surrogate function
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{X}}{A n-by-p numeric matrix where n is the number of data points,
p is the number of dimensions; the predictor variables.}

\item{\code{ys}}{A n-by-1 column vector; the response variable.}

\item{\code{sigma}}{A n-by-1 column vector or a scalar; the observational noise.}

\item{\code{true_f}}{A function; the function of which the surrogate is seeked.}

\item{\code{model}}{A variable for storing the fitted model.}

\item{\code{sample_fun}}{A function; the function to sample the next set of
points to evaluate using the surrogate function. By default, it samples
from the bounding hypercube of the variable `X`.}

\item{\code{select_fun}}{A function; the function to select the next point
to evaluate using the true function. By default, it picks the point that
has the highest predictive variance.}

\item{\code{in_sample_fit}}{The in-sample fit of the fitted model to the
training data X.}

\item{\code{next_to_consider}}{The next set of points to evaluate using
the surrogate function.}

\item{\code{out_of_sample_uncertainty}}{The out-of-sample uncertainty
associated with `next_to_consider`; the predictive variance.}

\item{\code{next_to_evaluate}}{The next point to evaluate using the true function.}

\item{\code{measure}}{The summary measure of the fitted model.}

\item{\code{debug}}{TRUE or FALSE, whether to use the debug mode.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-gp_surrogate-new}{\code{gp_surrogate$new()}}
\item \href{#method-gp_surrogate-update}{\code{gp_surrogate$update()}}
\item \href{#method-gp_surrogate-measure_fit_and_risk}{\code{gp_surrogate$measure_fit_and_risk()}}
\item \href{#method-gp_surrogate-clone}{\code{gp_surrogate$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gp_surrogate-new"></a>}}
\if{latex}{\out{\hypertarget{method-gp_surrogate-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Gaussian Process surrogate model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gp_surrogate$new(
  X,
  f,
  kernel = squared_exponential(),
  sigma = 0,
  sample_fun,
  select_fun,
  debug = FALSE,
  sample_n = 20,
  parallel = FALSE,
  mc.cores = 1,
  options = list(),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{A numeric matrix; the training data.}

\item{\code{f}}{A function; the function of which the surrogate is seeked.}

\item{\code{kernel}}{The kernel function of the Gaussian Process.}

\item{\code{sigma}}{The regularisation parameter of the Gaussian Process.}

\item{\code{sample_fun}}{sample_fun A function; the function to sample the next set of
points to evaluate using the surrogate function.}

\item{\code{select_fun}}{select_fun A function; the function to select the next point
to evaluate using the true function.}

\item{\code{debug}}{TRUE or FALSE, whether to use the debug mode.}

\item{\code{sample_n}}{A positive integer; the number of samples to draw in each iteration.
Note that this parameter is used only when `sample_fun` is not provided.}

\item{\code{parallel}}{TRUE or FALSE; whether to use parallel computing.}

\item{\code{mc.cores}}{A positive integer; the number of cores to use for parallel
computing. Only works when `parallel = TRUE`.}

\item{\code{options}}{Optional argument to pass to \code{optim}.}

\item{\code{...}}{Additional parameters to pass to \link{gp}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gp_surrogate-update"></a>}}
\if{latex}{\out{\hypertarget{method-gp_surrogate-update}{}}}
\subsection{Method \code{update()}}{
Update a fitted model with active learning
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gp_surrogate$update(parallel = FALSE, mc.cores = 1, options)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parallel}}{TRUE or FALSE; whether to use parallel computing.}

\item{\code{mc.cores}}{A positive integer; the number of cores to use for parallel
computing. Only works when `parallel = TRUE`.}

\item{\code{options}}{Optional argument to pass to \code{optim}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gp_surrogate-measure_fit_and_risk"></a>}}
\if{latex}{\out{\hypertarget{method-gp_surrogate-measure_fit_and_risk}{}}}
\subsection{Method \code{measure_fit_and_risk()}}{
Evaluate the fitted model using the in-sample fit and out-of-sample variance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gp_surrogate$measure_fit_and_risk()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gp_surrogate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-gp_surrogate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gp_surrogate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
