% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_with_derivative.R
\name{gp_d}
\alias{gp_d}
\title{Gaussian Process with derivative (SE kernel)}
\usage{
gp_d(X, y, dy, sigma = 0, sigma_d = 0, ...)
}
\arguments{
\item{X}{A numeric matrix; the data.}

\item{y}{A numeric vector; the data.}

\item{dy}{A numeric matrix; the derivative of y with respect to X.
If y is n x 1, X is n x p, then dy should be n by p, having the same
shape as X. Each column is a partial derivative, and each row is a
gradient.}

\item{sigma}{A positive number; the noise of the data.}

\item{sigma_d}{A positive number; the noise of the derivative.
Mostly needed as a mean of regularisation to combat numerical issues.}

\item{...}{Optional argument to pass to \code{optim}.}
}
\description{
Gaussian Process with derivative (SE kernel)
}
\examples{
\dontrun{
# Example 1
library(gptools2)
x <-  as.matrix(runif(10, -10, 10))
f <- sin
df <- cos
y <- f(x)
dy <- df(x)
model <- gp_d(x, y, dy, sigma = 1e-6, sigma_d = 1e-6)
pred_y <- predict_gp(model, x)
cbind(y, pred_y$mean, err = y - pred_y$mean)

test_x <- as.matrix(runif(10, -10, 10))
test_y <- f(test_x)
pred_y <- predict_gp_d(model, test_x)
cbind(test_y, pred_y$mean, err = test_y - pred_y$mean)

plot(x, y, pch = 19, xlim = c(-10, 10))
lines(s <- seq(-10, 10, 0.1), f(s), lty = 2)
points(test_x, test_y, pch = 19, col = 'blue')
points(test_x, pred_y$mean, col = 'green', cex = 3)


# Example 2
library(gptools2)
X <- as.matrix(expand.grid(
    seq(-5, 5, length.out = 6),
    seq(-5, 5, length.out = 6)
))
y <- sin(X[,1]) + X[,2]
dy <- cbind(cos(X[,1]), 1)
model <- gp_d(X, y, dy, sigma = 1e-6, sigma_d = 1e-6,
              control = list(trace = 3))
pred_y <- predict_gp_d(model, X)
cbind(y, pred_y$mean, err = y - pred_y$mean)

test_X <- as.matrix(expand.grid(
    runif(10, -4.5, 4.5),
    runif(10, -4.5, 4.5)  # avoid boundary effect
))
test_y <- sin(test_X[,1]) + test_X[,2]
pred_y <- predict_gp(model, test_X)
cbind(test_y, pred_y$mean, err = test_y - pred_y$mean)

# Plots
plot(X[,1] + X[,2], y, type = 'n',
     xlab = "x1 + x2", main = "f(x1, x2) = sin(x1) + x2")
local(for (x2 in c(test_X[,2])) {
    x1 <- seq(-5, 5, length.out = 40)
    y <- sin(x1) + x2
    lines(x1 + x2, y, lwd = 1, col = 1 + abs(x2))
})
points(rowSums(test_X), test_y, cex = 1, col = 1 + abs(test_X[,2]), pch = 19)
points(rowSums(test_X), pred_y$mean, cex = 2, col = 1 + abs(test_X[,2]))
}
}
