% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp.R
\name{gp}
\alias{gp}
\title{Gaussian Process}
\usage{
gp(X, y, kernel = squared_exponential(), sigma = 0, options = list())
}
\arguments{
\item{X}{A numeric matrix; the data.}

\item{y}{A numeric vector; the data.}

\item{kernel}{A kernel object, which is a named list of a list of
named parameters and an uninitialised kernel function.}

\item{sigma}{A positive number; the noise of the data.}

\item{options}{Optional argument to pass to \code{optim}.}
}
\description{
Gaussian Process
}
\examples{
\dontrun{
library(gptools2)
x <-  as.matrix(seq(-10, 10, 1.5))
f <- sin
y <- f(x)
model <- gp(x, y, sigma = 0)
pred_y <- predict_gp(model, x)
cbind(y, pred_y$mean, err = y - pred_y$mean)

test_x <- as.matrix(seq(-10, 10, 0.1))
test_y <- f(test_x)
pred_y <- predict_gp(model, test_x)
cbind(test_y, pred_y$mean, err = test_y - pred_y$mean)

plot(x, y, pch = 19, xlim = c(-10, 10))
lines(test_x, test_y, type = 'l', lty = 2)
lines(test_x, pred_y$mean, col = 'blue')
}
}
