% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active_learning.R
\name{active_learning}
\alias{active_learning}
\title{Active learning with surrogate function}
\usage{
active_learning(
  X,
  f,
  surrogate = gp_surrogate$new,
  max_iter,
  tol,
  persistence = 1,
  consecutive = -1,
  parallel = FALSE,
  mc.cores = 1,
  restart,
  options = list(),
  callback,
  ...
)
}
\arguments{
\item{X}{A list of evaluation points.}

\item{f}{A function; the objective function.}

\item{surrogate}{A function; the surrogate class of object.}

\item{max_iter}{A positive integer; the maximum iterations.}

\item{tol}{A numeric vector of length two; the mean-squared-error and 
out-of-sample-predictive variance tolerance for convergence.}

\item{persistence}{A positive integer; the number of times the tolerance 
should be reached before convergence. Use -1 to disable this option.}

\item{consecutive}{A positive integer; the number of consecutive times the tolerance 
should be reached before convergence. Use -1 to disable this option.}

\item{parallel}{TRUE or FALSE; whether to use parallel computing.}

\item{mc.cores}{A positive integer; the number of cores to use for parallel
computing. Only works when `parallel = TRUE`.}

\item{restart}{The fitted model from previous run.}

\item{options}{Optional argument to pass to \code{optim}.}

\item{callback}{Optional function to be called after each iteration of update;
this lets users examine the fitting process.}

\item{...}{Optional arguments to pass to the surrogate function.}
}
\value{
A model object returned by the surrogate function.
}
\description{
Active learning with surrogate function
}
\examples{
\dontrun{
library(gptools2)
s <- seq(-5, 5, length.out = 3)
X <- as.matrix(expand.grid(s, s))
f <- function(x) sin(x[1]) + x[2]

model <- active_learning(
    X, f, sigma = 1e-3,
    max_iter = 100, tol = c(0.1, 0.01)
)

# In-sample fit
pred_y <- predict_gp(model$model, X)
y <- map_row(X, f)
compare(y, pred_y$mean)

# Out-of-sample performance
new_X <- as.matrix(expand.grid(runif(10, -4, 4), runif(10, -4, 4)))
new_y <- map_row(new_X, f)
new_pred_y <- predict_gp(model$model, new_X)
compare(new_y, new_pred_y$mean)
}
}
