#' Absoute error between two vectors
#'
#' @param x A numeric vector.
#' @param y A numeric vector.
absolute_error <- function(x, y) {
    abs(x - y)
}


#' Relative error between two vectors
#'
#' @param x A numeric vector.
#' @param y A numeric vector.
relative_error <- function(x, y) {
    abs(x - y) / pmax(abs(x), abs(y), 1e-15)
}


#' Compare two vectors
#'
#' @param x A numeric vector.
#' @param y A numeric vector.
#' @param digits An integer indicating the number of decimal places
#' for `x` and `y`.
#'
#' @note All rounding operations occur after the calculation.
#'
#' @export
compare <- function(x, y, digits = 4) {
    clean <- function(x) round(x, digits)
    res <- cbind(clean(x), clean(y),
                 clean(relative_error(x, y)) * 100,
                 clean(absolute_error(x, y)))
    row.names(res) <- NULL
    colnames(res) <- c("x", "y", "rel_err(%)", "abs_err")
    res
}
