tvp.ds.func <- function(Yraw = Yraw,Xraw = Xraw, p = p, cons = cons, thin = thin, nsave = nsave, nburn = nburn, specification.list = specification.list, hyperprior.list = hyperprior.list){

###------------------------ Load packages -----------------------------------###
library(Matrix)
library(BayesLogit)
library(stochvol)
library(mvtnorm)
library(MASS)

###----------------------- Extract specifications ---------------------------###
list2env(specification.list,globalenv())
list2env(hyperprior.list,globalenv())

list2env(approx.list,globalenv())
list2env(ms.prior.list,globalenv())
list2env(ng.prior.list,globalenv())

###------------------------ Data set-up -------------------------------------###
if (is.null(Yraw)){
  # Do the VAR lag part and compute y based on p lags
  k.i <- ncol(Xraw)
  X <- mlag(Xraw, p)
  Yraw <- Xraw[(p+1):nrow(Xraw),,drop=F]
  X <- X[(p+1):nrow(X),]
  y <- Yraw[,target.var, drop = F]
  X.contemp <- Yraw[,contemp.var, drop = F]
  KKK <- ncol(X.contemp) #covariances
  KK <- k.i*p         # coefficients
  if(cons) X <- cbind(X,X.contemp, 1) else  X <- cbind(X, X.contemp)
}else{
  y <- Yraw
  X <- Xraw
  KK <- ncol(X)
}

K <- ncol(X)
T <- nrow(y)
M <- T
TK <- k <- K*T

Z.WN <- Z.RW <- matrix(0,T,k)

for (i in 1:T){
  Z.WN[i, (1+K*(i-1)):(K*i)] <- X[i,]
  Z.RW[i, 1:(i*K)] <- rep(X[i,],i)
}
if(rw.st) Z <- Z.RW else Z <- Z.WN

###------------ Initialization and starting values -------------------------###
# Initialize dynamic shrinkage process
if (evol_error %in% c("svol-z", "svol-n")){
  omega <- matrix(rnorm(T, 0, 1e-4), T, 1)
  evolParams <- initEvolParams(omega, evol_error = "DHS")
  lambda.t <- exp(evolParams$ht)
  phi <- rep(1e-5, K)
}else if (evol_error=="MS"){
  st <-  matrix(1, T, 1)
  s00 <- st
  #Initialize state vector
  ppnew <- matrix(1,T,1)*0.95
  qqnew <- matrix(1,T,1)*0.95
  ncrit <- round(0.1*T)
}else if(evol_error == "svol-n"){
  evolParams <- list(para = c(mu = -10, phi = 0.9, sigma = 0.2), latent = rep(-10, T))
}
lambda.00 <- lambda.t <- rep(1, T)

e.0   <-  5  ; e.1   <- 50
e.1.0 <-  1e2; e.1.1 <- 1
e.0.0 <-  1e2; e.0.1 <- 1

# Coeff prior for the constant coefficients and max.chg
Y.uni <- Xraw#[,1,drop =F]
X.uni <- mlag(Xraw,p)
Y.uni <- Y.uni[(p+1):nrow(Y.uni),]
X.uni <- X.uni[(p+1):nrow(X.uni),]

Mtilda <- ncol(Y.uni)
# Now get residual variances of univariate p-lag AR models
sigma_sq <- matrix(NA,Mtilda,1)
for (jj in 1:Mtilda){
  Ylag_i <- X.uni[,jj]
  Y_i <- Y.uni[,jj]
  alpha_i <- solve(crossprod(Ylag_i))%*%crossprod(Ylag_i,Y_i)
  sigma_sq[jj,1] <- crossprod(Y_i-Ylag_i%*%alpha_i)/(T-p)#[i,1] <- (1/(nrow(Yraw)-p))*t(Y_i-Ylag_i%*%alpha_i)%*%(Y_i-Ylag_i%*%alpha_i) 
}

sigma_sq <- rep(sigma_sq, p)
if(KKK>0) sigma_sq <- c(sigma_sq, sigma_sq[1:KKK])
if(cons) sigma_sq <- c(sigma_sq, 1)
names(sigma_sq) <- c(rep(colnames(Xraw), p), colnames(Xraw)[contemp.var], "cons")

# Prior variances
V0 <- 1e-4*diag(k) 
sigma.v0 <- v0.diag <- diag(V0)
V0inv <- diag(1/diag(V0))

if(prior.type == "HS"){
  max.chg <- rep(off.set.max*sigma_sq, T)
  V0.cons <- diag(K)*1e-3
  V0.cons.inv <- diag(1/diag(V0.cons))
  #Initialize HS prior
  psi.tvp.mat <- matrix(0, T, K)
  lambda.A <- matrix(1, T, K)
  nu.A <- matrix(1, T, K)
  tau.A <- matrix(1, T, K)
  zeta.A <- matrix(1, T, K)
  
  lambda.A.cons <- 1
  nu.A.cons <- 1
  tau.A.cons <- 1
  zeta.A.cons <- 1
}
# Prior mean
prior.part <- rep(0,k)
b0 <- rep(0,k)

MaxTrys <- 100 # In case that si containts < ncrit observations
Max.it <- 20   # Rejection sampler for lambda.t

b.tilde.hat <- matrix(0, TK,1) # Initialize TVPs

# Initialize SV
sv_priors <- specify_priors(
    mu = sv_normal(mean = 0, sd = 1), # prior on unconditional mean in the state equation
    phi = sv_beta(shape1 = 5, shape2 = 1.5), #informative prior to push the model towards a random walk in the state equation (for comparability)
    sigma2 = sv_gamma(shape = 0.5, rate = 300), # Gamma prior on the state innovation variance
    nu = sv_infinity(),
    rho = sv_constant(0))
  
# Initialization of SV processes
svdraw <- list(mu = 0, phi = 0.99, sigma = 0.01, nu = Inf, rho = 0, beta = NA, latent0 = 0)
  
ht <- rep(-3,T)
sigma <- rep(1, T) # Measurement error variances

# Hard thresholding, replaced by SAVS
ind <- diag(V0) < thrs
ind[] <- TRUE
sl.null <- !ind

# Stuff we need during MCMC sampling
I_T <- diag(T)
norm.Z.i <- apply(Z,2, function(x) sqrt(sum(x^2)))^2
norm.X.i <- apply(X,2, function(x) sqrt(sum(x^2)))^2

ntot <- nburn + thin*nsave
save.set <- seq(nburn+thin, ntot, thin)

###------------------------ Storage matrices --------------------------------###
beta.diff.store <- beta.store <- beta.sps.store <- array(NA,c(length(save.set),T,K))
A.store <- A.sps.store <- array(NA,c(length(save.set),K))
sigma2.store <- array(NA,c(length(save.set), T))
fit.store <- array(NA,c(length(save.set), T))
log.lambda.store <- array(NA,c(length(save.set),T))
v0.diag.store <- ind.store <- array(NA, c(length(save.set), T, K))
prob.store <- array(NA, c(length(save.set),1))
save.int <- 0

pb <- txtProgressBar(min = 0, max = ntot, style = 3) # Start progress bar
irep <- 1
for (irep in seq_len(ntot)){
###------------------------------ Step 1: -----------------------------------###
###-------------- Sample time-invariant part of the model -------------------###
###--------------------------------------------------------------------------###
# Step 1.1: Non-sparsified coefficients
X.cons <- X/sigma
Y.cons <- (y - Z%*%b.tilde.hat)/sigma

if (K > 1){
  V.post <- solve(crossprod(X.cons) + V0.cons.inv) 
}else{
  V.post <- try(solve(crossprod(X.cons) + V0.cons.inv), silent = T)
  if (is(V.post,"try-error")) V1 <- ginv(crossprod(X.cons) + V0.cons.inv)
}

A.post <- V.post%*%crossprod(X.cons,Y.cons)
A.draw <- try(A.post + t(chol(V.post))%*%rnorm(K), silent = T)
if (is(A.draw, "try-error")) A.draw <- mvrnorm(1, A.post, V.post)
  
# Step 1.2: SAVS step: zeta = 1, nu = nu
A.sparse <- matrix(0, K,1)
mu.jj <- 1/(abs(A.draw))^nu
A.sl.null <- (abs(A.draw)*norm.X.i) < mu.jj
A.sparse[!A.sl.null] <- (sign(A.draw)* 1/norm.X.i * ((abs(A.draw)*norm.X.i)-mu.jj))[!A.sl.null]
  
###------------------------------ Step 2: -----------------------------------###
###---- Sample HS hyperparameters for prior on the constant coefficients ----###
###--------------------------------------------------------------------------###
if(prior.type == "HS"){
hs_draw <- get.hs(bdraw=as.numeric(A.draw),lambda.hs=lambda.A.cons,nu.hs=nu.A.cons,tau.hs=tau.A.cons,zeta.hs=zeta.A.cons)
  
lambda.A.cons <- hs_draw$lambda
nu.A.cons <- hs_draw$nu
tau.A.cons <- hs_draw$tau
zeta.A.cons <- hs_draw$zeta
psi.cons <- hs_draw$psi+1e-8
}
V0.cons <- diag(psi.cons)
V0.cons.inv <- diag(1/psi.cons)
  
###------------------------------ Step 3: -----------------------------------###
###-------- Sample TVPs using the Bhattacharya et al. algorithm -------------###
###--------------------------------------------------------------------------###
if(tvp){
# Normalizing step (substract constant part, divide through error volatility)  
y_ <- (y - X%*%A.draw)/sigma    
X_ <- Matrix::bdiag(Z)/sigma    
  
# Sampling from (manipulated) prior variance-covariance matrix
v0.diag.restr <- v0.diag
v0.diag.restr[!ind] <- off.set.V0
u <- rnorm(k, 0, sqrt(v0.diag.restr)) # u ~ N(0, V0) 

XV0.full <- t(X_)*v0.diag.restr # V0 is diagonal!

delta <- rnorm(T, 0, 1) # delta ~ N(0, I)
v <- X_%*%u + delta   # v = X_*u + delta

if (sum(ind)==0){#Speed further up computations by noting that Mz = I_T
  w2 <- (y_ - v)
}else{# Restricted X_ for approximating inverse, dropped columns correspond to zero coefficients
  X__ <- Matrix::Matrix(X_[,ind, drop = F], sparse = TRUE) 
  XV0.restr <- t(X__)*v0.diag.restr[ind]   # Create full and restricted X%*%V0
  Mz <- X__%*%XV0.restr+I_T
  if(rw.st) w2 <- Matrix::solve(Mz, (y_ - v)) else w2 <- forwardsolve(Mz, (y_ - v)) 
}  
  
b.tilde.hat <- as.vector(u + XV0.full%*%w2)
b.tilde.mat <- t(matrix(b.tilde.hat,K,T))

###------------------------------ Step 4: -----------------------------------###
###------ Sample HS hyperparameters for prior on the TVP coefficients -------###
###--------------------------------------------------------------------------###
if(prior.type == "HS"){
  vecht <- rep(lambda.t, each = K)
  b.tilde.hs <- t(matrix(b.tilde.hat/sqrt(vecht),K,T)) 
  for(pp in 1:K){
    hs_draw <- get.hs(bdraw=b.tilde.hs[,pp],lambda.hs=lambda.A[,pp],nu.hs=nu.A[,pp],tau.hs=tau.A[1,pp],zeta.hs=zeta.A[1,pp])
    lambda.A[,pp] <- hs_draw$lambda
    nu.A[,pp] <- hs_draw$nu
    tau.A[,pp] <- hs_draw$tau
    zeta.A[,pp] <- hs_draw$zeta
    psi.tvp.mat[,pp] <- hs_draw$psi
  }
  psi.tvp <- as.vector(t(psi.tvp.mat)) + 1e-8
  
# create full prior variance matrix v0_t = lambda_t*psi.tvp
  v0.diag <- rep(lambda.t, each = K)*psi.tvp  
  v0.diag[v0.diag > max.chg] <- max.chg[v0.diag > max.chg]
}else{
  psi.tvp <- max.chg
  v0.diag <- rep(lambda.t, each = K)*psi.tvp
}
  
###------------------------------ Step 5: -----------------------------------###
###----------------------- SAVS step for b.tilde.hat ------------------------###
###--------------------------------------------------------------------------###
b.sparse <- matrix(0, TK,1)
mu.jj <- log(zeta) - nu*log(abs(b.tilde.hat))
mu.jj <- exp(mu.jj)
sl.null <- (abs(b.tilde.hat)*norm.Z.i) < mu.jj
if(sum(sl.null) < ceiling(length(sl.null)*tvp.perc)){
  sl.temp <- (abs(b.tilde.hat)*norm.Z.i) - mu.jj  
  sl.null <- (sl.temp > quantile(sl.temp, (1-tvp.perc)))
}

b.sparse[!sl.null] <- (sign(b.tilde.hat)* 1/norm.Z.i * ((abs(b.tilde.hat)*norm.Z.i)-mu.jj))[!sl.null]
 
###------------------------------ Step 6: -----------------------------------###
###-------------- Create indicator to restrict Z and V0   -------------------###
###--------------------------------------------------------------------------###
if(approx.type == "none" || irep < train.ind*nburn) 
{ 
  ind <- rep(TRUE, (T*K))
}else if(sum(ind) <= length(ind)*tvp.perc){
  ind <- (v0.diag > quantile(v0.diag, (1-tvp.perc)))
}else if(approx.type == "savs"){
  ind <- !sl.null
}else if(approx.type == "thrsh"){
  ind <- (v0.diag>thrs)
}

###------------------------------ Step 7: -----------------------------------###
###------------ Sample the global TVP shrinkage parameter -------------------###
###--------------------------------------------------------------------------###
if (evol_error %in% c("svol-z", "svol-n")){
  scale.mat <- t(matrix(sqrt(psi.tvp),K,T))
    
  omega <- sqrt(apply((b.tilde.mat/scale.mat)^2,1,sum))
  # Global shrinkage parameter (across all t's and i's)
  if(evol_error == "svol-z"){
    evolParams <- sampleEvolParams(omega = omega, evolParams = evolParams ,  sigma_e = 1, evol_error = "DHS", error_type = "logXiK", m_st = log(K) - 1/K, v_st2 = 2/K)
  }else if(evol_error == "svol-n"){
    evolParams <- sampleEvolParams(omega, evolParams,  sigma_e = 1, evol_error = "SV", error_type = "logXiK", m_st = log(K) - 1/K, v_st2 = 2/K)
  }
  lambda.t <- exp(evolParams$ht-evolParams$dhs_mean)
  tau <- exp(evolParams$dhs_mean)
  tau[tau > off.set.max] <- off.set.max 
  lambda.t <- lambda.t*tau

}else if (evol_error == "Mix"){
  scale.mat <- t(matrix(sqrt(psi.tvp),K,T))
  omega <- b.tilde.mat/scale.mat
  
  st <- matrix(0, T,1)
  for (t in seq_len(T)){
    pt0 <- prod(dnorm(omega[t,], 0, sqrt(tau0sq)))*(1-p.prior) + 1e-50
    pt1 <- prod(dnorm(omega[t,], 0, sqrt(tau1sq)))*(p.prior) + 1e-50
      
    pt <- pt1/(pt0+pt1)
    if (runif(1) > pt){
      st[t] <- 1
      sig.t <- tau1sq  
    }else{
      sig.t <- tau0sq
    } 
    lambda.t[t] <- sig.t
  }
  
  p.prior <- rbeta(1, sum(st)+e.0, (T-sum(st))+e.1)
    
}else if (evol_error =="MS"){
  scale.mat <- t(matrix(sqrt(psi.tvp),K,T))
  omega <- b.tilde.mat/scale.mat
  st_filt <- hamiltonfilter(sqrt(tau0sq),sqrt(tau1sq),ppnew,qqnew,omega)
  fprob <- st_filt$fprob;liki <- st_filt$lik
    
  s_sample <- getS(fprob,ppnew,qqnew,ncrit,MaxTrys)
  problems <- s_sample$prob;st <- s_sample$ST
    
  if (problems==1) st <- s00 else s00 <- st
    
  ms.tr <- table(factor(paste0(head(st,-1),tail(st,-1)), levels = c("00", "01", "10", "11")))
  p.draw <- rbeta(1, e.1.1 + ms.tr["11"], e.1.0 + ms.tr["10"])
  q.draw <- rbeta(1, e.0.0 + ms.tr["00"], e.0.1 + ms.tr["01"])
    
  ppnew <- rep(p.draw, T)
  qqnew <- rep(q.draw, T)
    
  lambda.t <- st*tau1sq + (1-st)*tau0sq
    
}else if(evol_error == "static"){
  lambda.t <- rep(1, T)
}
  
if(irep < train.ind*nburn) lambda.t[] <- 1
  
}else{
  b.tilde.hat  <- b.sparse <- rep(0, TK)
  ind <- rep(FALSE, TK)
  b.tilde.mat <- t(matrix(b.tilde.hat,K,T))
}
  
b.tilde.smp <- b.tilde.mat
if(rw.st) b.tilde.mat <- apply(b.tilde.mat, 2,cumsum)

###------------------------------ Step 8: -----------------------------------###
###----------------------- Sample error variances ---------------------------###
###--------------------------------------------------------------------------###
shocks <- y - X%*%A.draw - Z%*%b.tilde.hat
if (SV){
  svdraw <- svsample_fast_cpp(shocks, startpara = svdraw, startlatent = ht, priorspec = sv_priors)
  svdraw[c("mu", "phi", "sigma", "nu", "rho")] <- as.list(svdraw$para[, c("mu", "phi", "sigma", "nu", "rho")])
  ht <- t(svdraw$latent)
  ht[ht < -12] <- -12 
  sigma2.draw <- exp(as.numeric(ht))  
  sigma <- sqrt(sigma2.draw)
}else{
  sigma2.draw <- rep(1/rgamma(1,0.01+T/2, 0.01 + sum(shocks^2)/2),T)
  sigma <- sqrt(sigma2.draw)
}

###----------------------------- Final step: --------------------------------###
###------------------------------- Storage ----------------------------------###
###--------------------------------------------------------------------------###
if (irep %in% save.set){
  save.int <- save.int+1
  A.store[save.int,] <- A.draw
  A.sps.store[save.int,] <- A.sparse
  beta.store[save.int,,] <- b.tilde.mat 
  beta.diff.store[save.int,,] <- b.tilde.smp  
  beta.sps.store[save.int,,] <- t(matrix(b.sparse, K, T))
  sigma2.store[save.int,] <- sigma2.draw
  
  fit.store[save.int,] <- Z%*%b.tilde.hat+X%*%A.draw+rnorm(T, 0, sqrt(sigma2.draw))
  if(tvp){
    log.lambda.store[save.int,] <- log(lambda.t)
    v0.diag.store[save.int,,] <- t(matrix(v0.diag,K,T))
    ind.store[save.int,,] <- t(matrix(ind, K,T))
    prob.store[save.int,] <- sum(ind)/TK
  }
}
setTxtProgressBar(pb, irep)
}

return(list(A.store = A.store, A.sps.store = A.sps.store, beta.store = beta.store, beta.sps.store = beta.sps.store, beta.diff.store = beta.diff.store, sigma2.store = sigma2.store, fit.store = fit.store, log.lambda.store = log.lambda.store, v0.diag.store = v0.diag.store, ind.store = ind.store, prob.store = prob.store, M = M, K = K, KK = KK, KKK=KKK, T = T, X = X, y =y,Xraw = Xraw))
}