get.hs <- function(bdraw,lambda.hs,nu.hs,tau.hs,zeta.hs){
  k <- length(bdraw)
  if (is.na(tau.hs)){
    tau.hs <- 1   
  }else{
    tau.hs <- invgamma::rinvgamma(1,shape=(k+1)/2,rate=1/zeta.hs+sum(bdraw^2/lambda.hs)/2) 
  }
  
  lambda.hs <- invgamma::rinvgamma(k,shape=1,rate=1/nu.hs+bdraw^2/(2*tau.hs))

  nu.hs <- invgamma::rinvgamma(k,shape=1,rate=1+1/lambda.hs)
  zeta.hs <- invgamma::rinvgamma(1,shape=1,rate=1+1/tau.hs)
  
  ret <- list("psi"=(lambda.hs*tau.hs),"lambda"=lambda.hs,"tau"=tau.hs,"nu"=nu.hs,"zeta"=zeta.hs)
  return(ret)
}


mlag <- function(X,lag)
{
  p <- lag
  X <- as.matrix(X)
  Traw <- nrow(X)
  N <- ncol(X)
  Xlag <- matrix(0,Traw,p*N)
  for (ii in 1:p){
    Xlag[(p+1):Traw,(N*(ii-1)+1):(N*ii)]=X[(p+1-ii):(Traw-ii),(1:N)]
  }
  return(Xlag)  
}

#------------------------------ Functions for MS switching -------------------------------------------------#
GET_REG <- function(Y,X,B0,isigma0,gammas,sigma2,theta1=0.1,theta2=10,tvp=1){
  K <- ncol(X)
  isig <- as.numeric(solve(sigma2))
  psi_xx  <-  isig*(crossprod(X))
  V_post  <-  solve(psi_xx + diag(1/diag(DD)))
  
  a_post  <-  V_post%*%((crossprod(X,Y))*isig)
  alpha  <-  a_post + t(chol(V_post))%*%rnorm(K,0,1) # Draw alpha
  
return(list(a=alpha,g=gammas))
}
hamiltonfilter <- function(sigma1,sigma2,p,q,y){
  T <- nrow(y)
  #Initialise the Filter
  pr_tr <- rbind(c(p[1],1-q[1]),c(1-p[1],q[1]))
  A <- rbind(diag(2)-pr_tr,matrix(1,1,2))
  EN <- matrix(c(0,0,1),3,1)
  ett <- MASS::ginv(crossprod(A))%*%t(A)%*%EN
  if (any(is.na(ett))){
    ett <- c(0.5,0.5)
  }
  #Forward Filter
  lik <- 0
  fprob <- matrix(0,T,2)
  for (it in 1:T){
    pr_tr <- rbind(c(p[it],1-q[it]),c(1-p[it],q[it]))

    neta1 <- prod(dnorm(y[it,],0,sigma1)+1e-10)
    neta2 <- prod(dnorm(y[it,],0,sigma2)+1e-10)

    neta1[neta1 < 1e-50] <- 1e-50
    neta2[neta2 < 1e-50] <- 1e-50
    
    ett1 <- ett*rbind(neta1,neta2)
    
    fit <- sum(ett1)
    ett <- (pr_tr%*%ett1)/fit
    
    fprob[it,] <- t(ett1/fit)
    
    if (fit>0 && !is.na(fit)){
      lik <- lik+log(fit)
    }else{
      lik <- lik-10
    }
  }
  #browser()
  return(list(fprob=fprob,lik=lik))
}

getst <- function(fprob,p,q){
  T <- nrow(fprob)
  ST <- matrix(0,T,1)
  filtered <- matrix(0,T,1)
  
  p00 <- fprob[T,1]
  p01 <- fprob[T,2]
  r <- runif(1,0,1)
  ST[T,1] <- (r>=(p00/(p00+p01)))
  #go backwards
  for (it in (T-1):1){
    pr_tr <- rbind(c(p[it],1-q[it]),c(1-p[it],q[it]))
    if (ST[it+1]==0){
      p00 <- pr_tr[1,1]*fprob[it,1]
      p01 <- pr_tr[1,2]*fprob[it,2]
    }else if (ST[it+1]==1){
      p00 <- pr_tr[2,1]*fprob[it,1]
      p01 <- pr_tr[2,2]*fprob[it,2]
    }
    #sample regime numbers
    r <- runif(1,0,1)
    alph <- (p00/(p00+p01))
    if (r<alph){
      ST[it] <- 0
    }else{
      ST[it] <- 1
    }
    filtered[it] <- alph
  }
  
  return(list(ST,filtered))
}
getS <- function(fprob,p,q,Ncrit,maxdraws){
  PROBLEM <- 0
  j <- 1
  chck <- -1
  while(j<maxdraws && chck<0){
    ST1 <- getst(fprob,p,q)
    ST <- ST1[[1]]
    
    check1 <- length(ST[!duplicated(ST)])==2
    T1 <- sum(ST==0)
    T2 <- sum(ST==1)
    check2 <- T1>=Ncrit
    check3 <-  T2>=Ncrit# T2 <30#CHGGGGGGGG
    if (check1+check2+check3==3){
      chck=10
    }else{
      j=j+1
    }
  }
  if (check1+check2+check3<3){
    PROBLEM=1
  }
  return(list(ST=ST,prob=PROBLEM,smooth=ST1[[2]]))
}

getystarF <- function(s,zall,gammax){
  T <- nrow(zall)
  ystar <- matrix(0,T,1)
  pmatT <- matrix(0,T,4)  
  
  mm <- zall%*%gammax
  vv <- 1
  
  tempP <- -zall[,1:(ncol(zall)-1)]%*%gammax[1:(nrow(gammax)-1)]
  tempQ <- (-zall[,1:(ncol(zall)-1)]%*%gammax[1:(nrow(gammax)-1)])-gammax[length(gammax)]
  
  pmatT[,1] <- pnorm(tempP)
  pmatT[,2] <- 1-pmatT[,1]
  pmatT[,4] <- 1-pnorm(tempQ)
  pmatT[,3] <- 1-pmatT[,4]  
  
  for (i in 1:T){
    if (s[i]==0){
      ystar[i] <- rtruncnorm(1,a=-Inf,b=0,mm[[i]],vv)
    }else if (s[i]==1){
      ystar[i] <-  rtruncnorm(1,a=0,b=Inf,mm[[i]],vv)#1
    }
  }
  return(list(pmat=pmatT,ystar=ystar))
}
bernoulli <- function(p){
  u <- runif(1)
  if (u<p){
    x=0
  }else{
    x=1
  }
  return(x)
}

#------------------------------ Functions for DSP  -------------------------------------------------#
sampleAR1 = function(h_yc, h_phi, h_sigma_eta_t, prior_dhs_phi = NULL){
  
  # Compute dimensions:
  n = nrow(h_yc); p = ncol(h_yc)
  
  # Loop over the j=1:p
  for(j in 1:p){
    
    # Compute "regression" terms for dhs_phi_j:
    y_ar = h_yc[-1,j]/h_sigma_eta_t[,j] # Standardized "response"
    x_ar = h_yc[-n,j]/h_sigma_eta_t[,j] # Standardized "predictor"
    
    # Using Beta distribution:
    if(!is.null(prior_dhs_phi)){
      
      # Check to make sure the prior params make sense
      if(length(prior_dhs_phi) != 2) stop('prior_dhs_phi must be a numeric vector of length 2')
      
      dhs_phi01 = (h_phi[j] + 1)/2 # ~ Beta(prior_dhs_phi[1], prior_dhs_phi[2])
      
      # Slice sampler when using Beta prior:
      dhs_phi01 = uni.slice(dhs_phi01, g = function(x){
        -0.5*sum((y_ar - (2*x - 1)*x_ar)^2) +
          dbeta(x, shape1 = prior_dhs_phi[1], shape2 = prior_dhs_phi[2], log = TRUE)
      }, lower = 0, upper = 1)[1]#}, lower = 0.005, upper = 0.995)[1] #
      
      h_phi[j] = 2*dhs_phi01 - 1
      
    } else {
      # For h_phi ~ Unif(-1, 1), the posterior is truncated normal
      h_phi[j] = rtrunc(n = 1, spec = 'norm',
                        a = -1, b = 1,
                        mean = sum(y_ar*x_ar)/sum(x_ar^2),
                        sd = 1/sqrt(sum(x_ar^2)))
    }
  }
  h_phi
}
initDHS = function(omega){
  
  # "Local" number of time points
  omega = as.matrix(omega)
  n = nrow(omega); p = ncol(omega)
  
  # Initialize the log-volatilities:
  ht = log(omega^2 + 0.0001)
  
  # Initialize the AR(1) model to obtain unconditional mean and AR(1) coefficient
  arCoefs = apply(ht, 2, function(x){
    params = try(arima(x, c(1,0,0))$coef, silent = TRUE); if(class(params) == "try-error") params = c(0.8, mean(x)/(1 - 0.8))
    params
  })
  dhs_mean = arCoefs[2,]; dhs_phi = arCoefs[1,]; dhs_mean0 = mean(dhs_mean)
  
  # Initialize the SD of log-vol innovations simply using the expectation:
  sigma_eta_t = matrix(pi, nr = n-1, nc = p)
  sigma_eta_0 = rep(pi, p) # Initial value
  
  # Evolution error SD:
  sigma_wt = exp(ht/2)
  
  list(sigma_wt = sigma_wt, ht = ht, dhs_mean = dhs_mean, dhs_phi = dhs_phi, sigma_eta_t = sigma_eta_t, sigma_eta_0 = sigma_eta_0, dhs_mean0 = dhs_mean0)
}
sampleDSP = function(evol_error, omega, evolParams, sigma_e = 1, prior_dhs_phi = c(10,2), alphaPlusBeta = 1, error_type, m_st, v_st2){
  #' Sample the dynamic shrinkage process parameters
  #'
  #' Compute one draw for each of the parameters in the dynamic shrinkage process
  #' for the special case in which the shrinkage parameter \code{kappa ~ Beta(alpha, beta)}
  #' with \code{alpha = beta}. The primary example is the dynamic horseshoe process with
  #' \code{alpha = beta = 1/2}.
  #'
  #' @param omega \code{T x p} matrix of evolution errors
  #' @param evolParams list of parameters to be updated (see Value below)
  #' @param sigma_e the observation error standard deviation; for (optional) scaling purposes
  #' @param prior_dhs_phi the parameters of the prior for the log-volatilty AR(1) coefficient \code{dhs_phi};
  #' either \code{NULL} for uniform on [-1,1] or a 2-dimensional vector of (shape1, shape2) for a Beta prior
  #' on \code{[(dhs_phi + 1)/2]}
  #' @param alphaPlusBeta For the symmetric prior kappa ~ Beta(alpha, beta) with alpha=beta,
  #' specify the sum [alpha + beta]
  #' @return List of relevant components:
  #' \itemize{
  #' \item the \code{T x p} evolution error standard deviations \code{sigma_wt},
  #' \item the \code{T x p} log-volatility \code{ht}, the \code{p x 1} log-vol unconditional mean(s) \code{dhs_mean},
  #' \item the \code{p x 1} log-vol AR(1) coefficient(s) \code{dhs_phi},
  #' \item the \code{T x p} log-vol innovation standard deviations \code{sigma_eta_t} from the Polya-Gamma priors,
  #' \item the \code{p x 1} initial log-vol SD \code{sigma_eta_0},
  #' \item and the mean of log-vol means \code{dhs_mean0} (relevant when \code{p > 1})
  #' }
  #'
  #' @note The priors induced by \code{prior_dhs_phi} all imply a stationary (log-) volatility process.
  #'
  #' @import BayesLogit
  #' @export
  # Store the DSP parameters locally:
  ht = evolParams$ht; dhs_mean = evolParams$dhs_mean; dhs_phi = evolParams$dhs_phi; sigma_eta_t = evolParams$sigma_eta_t; sigma_eta_0 = evolParams$sigma_eta_0; dhs_mean0 = evolParams$dhs_mean0
  
  # "Local" number of time points
  ht = as.matrix(ht)
  n = nrow(ht); p = ncol(ht)
  
  # Sample the log-volatilities using AWOL sampler
  ht = sampleLogVols(h_y = omega, h_prev = ht, h_mu = dhs_mean, h_phi=dhs_phi, h_sigma_eta_t = sigma_eta_t, h_sigma_eta_0 = sigma_eta_0, error_type = error_type, m_st = m_st, v_st2 = v_st2)
  
  # Compute centered log-vols for the samplers below:
  ht_tilde = ht - tcrossprod(rep(1,n), dhs_mean)
  
  # Sample AR(1) parameters
  # Note: dhs_phi = 0 means non-dynamic HS, while dhs_phi = 1 means RW, in which case we don't sample either
  if(!all(dhs_phi == 0) && !all(dhs_phi == 1)) dhs_phi = sampleAR1(h_yc = ht_tilde, h_phi = dhs_phi, h_sigma_eta_t = sigma_eta_t, prior_dhs_phi = prior_dhs_phi)
  
  # Sample the evolution error SD of log-vol (i.e., Polya-Gamma mixing weights)
  eta_t = ht_tilde[-1,] - tcrossprod(rep(1,n-1), dhs_phi)*ht_tilde[-n, ]       # Residuals
  if(evol_error == "DHS"){
    sigma_eta_t = matrix(1/sqrt(rpg(num = (n-1)*p, h = alphaPlusBeta, z = eta_t)), nc = p) # Sample
    sigma_eta_0 = 1/sqrt(rpg(num = p, h = 1, z = ht_tilde[1,]))                # Sample the inital
  }else if(evol_error == "SV"){
    sigma2_eta_t <- 1/rgamma(1,0.03+n/2, 3 + crossprod(eta_t)/2)

    #Sample initial value
    #C00 <- sigma2_eta_t/(1-dhs_phi^2)
    #C00 <- 0.0001
    #sigma_eta_0 <- sqrt(rnorm(1,as.numeric(dhs_mean),sqrt(C00)))
    sigma_eta_0 <- sqrt(sigma2_eta_t/(1-dhs_phi^2))
    sigma_eta_t <- matrix(rep(sqrt(sigma2_eta_t), n-1))
  }
  
  # Sample the unconditional mean(s), unless dhs_phi = 1 (not defined)
  if(!all(dhs_phi == 1)){
    if(p > 1){
      # Assume a hierarchy of the global shrinkage params across j=1,...,p
      muSample = sampleLogVolMu(h = ht, h_mu = dhs_mean, h_phi = dhs_phi, h_sigma_eta_t = sigma_eta_t, h_sigma_eta_0 = sigma_eta_0, h_log_scale = dhs_mean0);
      dhs_mean = muSample$dhs_mean
      dhs_mean0 = sampleLogVolMu0(h_mu = dhs_mean, h_mu0 = dhs_mean0, dhs_mean_prec_j = muSample$dhs_mean_prec_j, h_log_scale = log(sigma_e^2))
      dhs_mean <-  rep(0, p); dhs_mean0 <- 0
    } else {
      # p = 1
      muSample = sampleLogVolMu(h = ht, h_mu = dhs_mean, h_phi = dhs_phi, h_sigma_eta_t = sigma_eta_t, h_sigma_eta_0 = sigma_eta_0, h_log_scale = log(sigma_e^2));
      dhs_mean = dhs_mean0 = muSample$dhs_mean # save dhs_mean0 = dhs_mean for coding convenience later
      dhs_mean <- rep(0, p); dhs_mean0 <- 0
    }
    
  } else {dhs_mean = rep(0, p); dhs_mean0 = 0} # When RW for log-vols, fix unconditional mean for identifiability
  
  # Evolution error SD:
  sigma_wt = exp(ht/2)
  
  # Return the same list, but with the new values
  list(sigma_wt = sigma_wt, ht = ht, dhs_mean = dhs_mean, dhs_phi = dhs_phi, sigma_eta_t = sigma_eta_t, sigma_eta_0 = sigma_eta_0, dhs_mean0 = dhs_mean0)
}

sampleEvolParams = function(omega, evolParams,  sigma_e = 1, evol_error = "DHS", error_type = error_type, m_st = m_st, v_st2 = v_st2){
  #' Sampler evolution error variance parameters
  #'
  #' Compute one draw of evolution error variance parameters under the various options:
  #' \itemize{
  #' \item dynamic horseshoe prior ('DHS');
  #' \item horseshoe prior ('HS');
  #' \item normal-inverse-gamma prior ('NIG').
  #' }
  #'
  #' @param omega \code{T x p} matrix of evolution errors
  #' @param evolParams list of parameters pertaining to each \code{evol_error} type to be updated
  #' @param sigma_e the observation error standard deviation; for (optional) scaling purposes
  #' @param evol_error the evolution error distribution; must be one of
  #' 'DHS' (dynamic horseshoe prior), 'HS' (horseshoe prior), or 'NIG' (normal-inverse-gamma prior)
  #' @return List of relevant components in \code{evolParams}: \code{sigma_wt}, the \code{T x p} matrix of evolution standard deviations,
  #' and additional parameters associated with the DHS and HS priors.
  #'
  #' @note The list \code{evolParams} is specific to each \code{evol_error} type,
  #' but in each case contains the evolution error standard deviations \code{sigma_wt}.
  #'
  #' @note To avoid scaling by the observation standard deviation \code{sigma_e},
  #' simply use \code{sigma_e = 1} in the functional call.
  #'
  #' @import stochvol
  #' @export
  # Check:
  if(!((evol_error == "DHS") || (evol_error == "HS") || (evol_error == "BL") || (evol_error == "SV") || (evol_error == "NIG"))) stop('Error type must be one of DHS, HS, BL, SV, or NIG')
  
  # Make sure omega is (n x p) matrix
  omega = as.matrix(omega); n = nrow(omega); p = ncol(omega)
  
  if(evol_error %in% c("SV", "DHS")) return(sampleDSP(evol_error = evol_error, omega = omega, evolParams = evolParams, sigma_e = sigma_e, prior_dhs_phi = c(10,2), alphaPlusBeta = 1, error_type = error_type, m_st = m_st, v_st2 = v_st2))
  
  if(evol_error == "HS"){
    
    # For numerical reasons, keep from getting too small
    hsOffset = tcrossprod(rep(1,n), apply(omega, 2, function(x) any(x^2 < 10^-16)*max(10^-8, mad(x)/10^6)))
    hsInput2 = omega^2 + hsOffset
    
    # Local scale params:
    evolParams$tauLambdaj = matrix(rgamma(n = n*p, shape = 1, rate = evolParams$xiLambdaj + hsInput2/2), nr = n)
    evolParams$xiLambdaj = matrix(rgamma(n = n*p, shape = 1, rate = evolParams$tauLambdaj + tcrossprod(rep(1,n), evolParams$tauLambda)), nr = n)
    
    # Global scale params:
    evolParams$tauLambda = rgamma(n = p, shape = 0.5 + n/2, colSums(evolParams$xiLambdaj) + evolParams$xiLambda)
    #evolParams$xiLambda = rgamma(n = p, shape = 1, rate = evolParams$tauLambda + 1/sigma_e^2)
    evolParams$xiLambda = rgamma(n = p, shape = 1, rate = evolParams$tauLambda + 1)
    
    evolParams$sigma_wt = 1/sqrt(evolParams$tauLambdaj)
    
    return(evolParams)
  }
  if(evol_error == "BL"){
    
    # For numerical reasons, keep from getting too small
    hsOffset = tcrossprod(rep(1,n), apply(omega, 2, function(x) any(x^2 < 10^-16)*max(10^-8, mad(x)/10^6)))
    hsInput2 = omega^2 + hsOffset
    
    # 1/tau_j^2 is inverse-gaussian (NOTE: this is very slow!)
    evolParams$tau_j = matrix(sapply(matrix(hsInput2), function(x){1/sqrt(rig(n = 1,
                                                                              mean = sqrt(evolParams$lambda2*sigma_e^2/x), # already square the input
                                                                              scale = 1/evolParams$lambda2))}), nr = n)
    # Note: should be better priors for lambda2
    evolParams$lambda2 = rgamma(n = 1,
                                shape = 1 + n*p,
                                rate = 2 + sum(evolParams$tau_j^2)/2)
    
    # For Bayesian lasso, scale by sigma_e:
    evolParams$sigma_wt = sigma_e*evolParams$tau_j
    
    return(evolParams)
  }
  #if(evol_error == "SV") return(sampleSVparams(omega = omega, svParams = evolParams))
  #if(evol_error == "SV") return(sampleSVparams0(omega = omega, svParams = evolParams))
  if(evol_error == "NIG") {
    evolParams = list(sigma_wt = tcrossprod(rep(1,n),
                                            apply(omega, 2,
                                                  function(x) 1/sqrt(rgamma(n = 1, shape = n/2 + 0.01, rate = sum(x^2)/2 + 0.01)))))
    return(evolParams)
  }
}
initEvolParams = function(omega, evol_error = "DHS"){
  
  # Check:
  if(!((evol_error == "DHS") || (evol_error == "HS") || (evol_error == "BL") || (evol_error == "SV") ||(evol_error == "NIG"))) stop('Error type must be one of DHS, HS, BL, SV, or NIG')
  
  # Make sure omega is (n x p) matrix
  omega = as.matrix(omega); n = nrow(omega); p = ncol(omega)
  
  if(evol_error == "DHS") return(initDHS(omega))
  
  if(evol_error == "HS"){
    tauLambdaj = 1/omega^2;
    xiLambdaj = 1/(2*tauLambdaj); tauLambda = 1/(2*colMeans(xiLambdaj)); xiLambda = 1/(tauLambda + 1)
    
    # Parameters to store/return:
    return(list(sigma_wt = 1/sqrt(tauLambdaj), tauLambdaj = tauLambdaj, xiLambdaj = xiLambdaj, tauLambda = tauLambda, xiLambda = xiLambda))
  }
  if(evol_error == "BL"){
    tau_j = abs(omega); lambda2 = mean(tau_j)
    return(list(sigma_wt = tau_j, tau_j = tau_j, lambda2 = lambda2))
  }
  if(evol_error == "SV") return(initSV(omega))
  if(evol_error == "NIG") return(list(sigma_wt = tcrossprod(rep(1,n), apply(omega, 2, function(x) sd(x, na.rm=TRUE)))))
}
ncind = function(y,mu,sig,q){
  sample(1:length(q),
         size = 1,
         prob = q*dnorm(y,mu,sig))
}
sampleLogVols = function(h_y, h_prev, h_mu, h_phi, h_sigma_eta_t, h_sigma_eta_0, error_type, m_st, v_st2){
  
  # Compute dimensions:
  h_prev = as.matrix(h_prev) # Just to be sure (T x p)
  n = nrow(h_prev); p = ncol(h_prev)
  
  # Mixture params: mean, variance, and weights
  # Kim, Shephard, Chib (1998) 7-component mixture:
  #m_st  = c(-11.40039, -5.24321, -9.83726, 1.50746,  -0.65098, 0.52478,  -2.35859)
  #v_st2 = c(5.795960,  2.613690, 5.179500, 0.167350, 0.640090, 0.340230, 1.262610)
  #q     = c(0.007300,  0.105560, 0.000020, 0.043950, 0.340010, 0.245660, 0.257500)
  
  # Omori, Chib, Shephard, Nakajima (2007) 10-component mixture:
  if(error_type == "logXi1"){
    m_st  = c(1.92677, 1.34744, 0.73504, 0.02266, -0.85173, -1.97278, -3.46788, -5.55246, -8.68384, -14.65000)
    v_st2 = c(0.11265, 0.17788, 0.26768, 0.40611,  0.62699,  0.98583,  1.57469,  2.54498,  4.16591,   7.33342)
    q     = c(0.00609, 0.04775, 0.13057, 0.20674,  0.22715,  0.18842,  0.12047,  0.05591,  0.01575,   0.00115)
  }else if(error_type == "logXiK"){
    m_st  = m_st
    v_st2 = v_st2
  }
  
  # Add an offset: common for all times, but distict for each j=1,...,p
  yoffset = tcrossprod(rep(1,n),
                       apply(as.matrix(h_y), 2,
                             function(x) any(x^2 < 10^-16)*max(10^-8, mad(x)/10^6)))
  
  # This is the response in our DLM, log(y^2)
  ystar = log(h_y^2 + yoffset)
  
  # Sample the mixture components
  #z = draw.indicators(res = ystar-h_prev, nmix = list(m = m_st, v = v_st2, p = q))
  if(error_type == "logXi1"){
    z = sapply(ystar-h_prev, ncind, m_st, sqrt(v_st2), q)
  }else if(error_type == "logXiK"){
    z = rep(1,n)
  }
  
  # Subset mean and variances to the sampled mixture components; (n x p) matrices
  m_st_all = matrix(m_st[z], nr=n); v_st2_all = matrix(v_st2[z], nr=n)
  
  # Joint AWOL sampler for j=1,...,p:
  
  # Constant (but j-specific) mean
  h_mu_all = tcrossprod(rep(1,n), h_mu)
  
  # Constant (but j-specific) AR(1) coef
  h_phi_all = tcrossprod(rep(1,n), h_phi)
  
  # Linear term:
  linht = matrix((ystar - m_st_all - h_mu_all)/v_st2_all)
  
  # Evolution precision matrix (n x p)
  evol_prec_mat = matrix(0, nr = n, nc = p);
  evol_prec_mat[1,] = 1/h_sigma_eta_0^2;
  evol_prec_mat[-1,] = 1/h_sigma_eta_t^2;
  
  # Lagged version, with zeros as appropriate (needed below)
  evol_prec_lag_mat = matrix(0, nr = n, nc = p);
  evol_prec_lag_mat[1:(n-1),] = evol_prec_mat[-1,]
  
  # Diagonal of quadratic term:
  Q_diag = matrix(1/v_st2_all +  evol_prec_mat + h_phi_all^2*evol_prec_lag_mat)
  
  # Off-diagonal of quadratic term:
  Q_off = matrix(-h_phi_all*evol_prec_lag_mat)[-(n*p)]
  
  # Quadratic term:
  QHt_Matrix = bandSparse(n*p, k = c(0,1), diag = list(Q_diag, Q_off), symm = TRUE)
  #QHt_Matrix = as.spam.dgCMatrix(as(bandSparse(n*p, k = c(0,1), diag = list(Q_diag, Q_off), symm = TRUE),"dgCMatrix"))
  
  # Cholesky:
  chQht_Matrix = Matrix::chol(QHt_Matrix)
  
  # Sample the log-vols:
  hsamp = h_mu_all + matrix(Matrix::solve(chQht_Matrix,Matrix::solve(Matrix::t(chQht_Matrix), linht) + rnorm(length(linht))), nr = n)
  #hsamp = h_mu_all +matrix(rmvnorm.canonical(n = 1, b = linht, Q = QHt_Matrix, Rstruct = cholDSP0))
  
  
  # Return the (uncentered) log-vols
  hsamp
}

uni.slice <- function (x0, g, w=1, m=Inf, lower=-Inf, upper=+Inf, gx0=NULL)
{
  # Check the validity of the arguments.
  
  if (!is.numeric(x0) || length(x0)!=1
      || !is.function(g)
      || !is.numeric(w) || length(w)!=1 || w<=0
      || !is.numeric(m) || !is.infinite(m) && (m<=0 || m>1e9 || floor(m)!=m)
      || !is.numeric(lower) || length(lower)!=1 || x0<lower
      || !is.numeric(upper) || length(upper)!=1 || x0>upper
      || upper<=lower
      || !is.null(gx0) && (!is.numeric(gx0) || length(gx0)!=1))
  {
    stop ("Invalid slice sampling argument")
  }
  
  # Keep track of the number of calls made to this function.
  #uni.slice.calls <<- uni.slice.calls + 1
  
  # Find the log density at the initial point, if not already known.
  
  if (is.null(gx0))
  { #uni.slice.evals <<- uni.slice.evals + 1
    gx0 <- g(x0)
  }
  
  # Determine the slice level, in log terms.
  
  logy <- gx0 - rexp(1)
  
  # Find the initial interval to sample from.
  
  u <- runif(1,0,w)
  L <- x0 - u
  R <- x0 + (w-u)  # should guarantee that x0 is in [L,R], even with roundoff
  
  # Expand the interval until its ends are outside the slice, or until
  # the limit on steps is reached.
  
  if (is.infinite(m))  # no limit on number of steps
  {
    repeat
    { if (L<=lower) break
      #uni.slice.evals <<- uni.slice.evals + 1
      if (g(L)<=logy) break
      L <- L - w
    }
    
    repeat
    { if (R>=upper) break
      #uni.slice.evals <<- uni.slice.evals + 1
      if (g(R)<=logy) break
      R <- R + w
    }
  }
  
  else if (m>1)  # limit on steps, bigger than one
  {
    J <- floor(runif(1,0,m))
    K <- (m-1) - J
    
    while (J>0)
    { if (L<=lower) break
      #uni.slice.evals <<- uni.slice.evals + 1
      if (g(L)<=logy) break
      L <- L - w
      J <- J - 1
    }
    
    while (K>0)
    { if (R>=upper) break
      #uni.slice.evals <<- uni.slice.evals + 1
      if (g(R)<=logy) break
      R <- R + w
      K <- K - 1
    }
  }
  
  # Shrink interval to lower and upper bounds.
  
  if (L<lower)
  { L <- lower
  }
  if (R>upper)
  { R <- upper
  }
  
  # Sample from the interval, shrinking it on each rejection.
  
  repeat
  {
    x1 <- runif(1,L,R)
    
    #uni.slice.evals <<- uni.slice.evals + 1
    gx1 <- g(x1)
    
    if (gx1>=logy) break
    
    if (x1>x0)
    { R <- x1
    }
    else
    { L <- x1
    }
  }
  
  # Return the point sampled, with its log density attached as an attribute.
  
  attr(x1,"log.density") <- gx1
  return (x1)
  
}
sampleLogVolMu = function(h, h_mu, h_phi, h_sigma_eta_t, h_sigma_eta_0, h_log_scale = 0){
  
  # Compute "local" dimensions:
  n = nrow(h); p = ncol(h)
  
  # Sample the precision term(s)
  dhs_mean_prec_j = rpg(num = p, h = 1, z = h_mu - h_log_scale)
  
  # Now, form the "y" and "x" terms in the (auto)regression
  y_mu = (h[-1,] - tcrossprod(rep(1,n-1), h_phi)*h[-n,])/h_sigma_eta_t;
  x_mu = tcrossprod(rep(1,n-1), 1 - h_phi)/h_sigma_eta_t
  
  # Include the initial sd?
  #if(!is.null(h_sigma_eta_0)){y_mu = rbind(h[1,]/h_sigma_eta_0, y_mu); x_mu = rbind(1/h_sigma_eta_0, x_mu)}
  y_mu = rbind(h[1,]/h_sigma_eta_0, y_mu);
  x_mu = rbind(1/h_sigma_eta_0, x_mu)
  
  # Posterior SD and mean:
  postSD = 1/sqrt(colSums(x_mu^2) + dhs_mean_prec_j)
  postMean = (colSums(x_mu*y_mu) + h_log_scale*dhs_mean_prec_j)*postSD^2
  dhs_mean = rnorm(n = p, mean = postMean, sd = postSD)
  
  list(dhs_mean = dhs_mean, dhs_mean_prec_j = dhs_mean_prec_j)
}
