% function[beta,se,t] = qreg(y,x,q)
% qreg.m computes the quantile regression estimate, standard error estimate,
% and the t-statistic for testing beta=0
%
% 		INPUT	y: dependent variable
%				x: regressor (nxk vector)
%               q: quantile
%
% 		OUTPUT	beta: (kx1 vector) parameter estimate
%				se: (kx1 vector) standard error estimate
%				t: (kx1 vector)	t-statistic for testing
%					each element of beta is 0.
%_______________________________________________________________________

function[beta,se,t]=qreg(y,x,q)

[n,k] = size(x);
beta = rq_fnm(x,y,q);
res = y - x*beta;		% residuals: nx1 vector

S = (1/n)*x'*x;
h = 1.364*((2*sqrt(pi))^(-1/5))*sqrt(var(res))*(n^(-1/5)); % bandwidth (Silverman's rule of thumb)
J = (1/(n*h))*((normpdf(res/h)*ones(1,k)).*x)'*x;
vc = (1/n)*(q-q^2)*inv(J')*S*inv(J); % variance estimate
se = (sqrt(diag(vc))); % standard error estimate

t = beta./se;			% t-stat for testing beta=0