% function[beta,se,t] = ols(y,x)
% ols.m computes the OLS estimate, standard error estimate,
% and the t-statistic for testing beta=0
%
%								Katsumi Shimotsu, January 2009
%
% 		INPUT	y: dependent variable
%				x: regressor (nxk vector)
%
% 		OUTPUT	beta: (kx1 vector) parameter estimate
%				se: (kx1 vector) starndard error estimate
%				t: (kx1 vector)	t-statistic for testing
%					each element of beta is 0.
%_______________________________________________________________________

function[beta,se,t]=ols(y,x)

[n,k] = size(x);
beta = inv(x'*x)*x'*y;
res = y - x*beta;		% residuals

ss = res'*res/(n-k);	% s^2=SSR/(n-k)
v = ss*inv(x'*x);		% OLS variance estimate

se = sqrt(diag(v));		% standard error estimate
t = beta./se;			% t-stat for testing beta=0
