function [gamma_initial,d_hat,phi_hat,gamma_hat,c_hat,sigma_hat,M_hat,G_hat,ybar,...
    pvalue_linear,LM_linear,pvalue_robust_linear,LM_robust_linear,...
    pvalue,LM,pvalue_robust,LM_robust,u_hat] = ...
    nlestimation(y,s,T,M,p,robust)

flag_M = isempty(M);

gamma    = [];
c        = [];
d_linear = 0.4;

ybar = mean(y);
y = y - ybar;

% linear estimation
options = optimset('Display','off','GradObj','off','MaxFunEvals',1e10,...
        'MaxIter',6000,'TolFun',1e-8,'DerivativeCheck','off',...
        'TolX',1e-8); %'LineSearchType','cubicpoly',
d_linear= fminunc(@(d_linear) msecost(d_linear,y,p,T),d_linear,options);
     
% construct filtered series
%v = fracfilter(y,d_linear);
v = fractint_filter_d(y,d_linear,100);

% construct lagged series
V = zeros(T-p,p);
for i=1:p
    V(:,i) = v(p-i+1:T-i);
end
v = v(p+1:end);
s = s(p+1:end);

phi_linear = pinv(V'*V)*V'*v;

% residuals under linear estimation
u_linear = v - V*phi_linear;
z_linear = invfilter(u_linear,d_linear,T-p);

% linearity testing
if flag_M == 1
    [rejectH0_linear,pvalue_linear,LM_linear,...
        rejectH0_robust_linear,pvalue_robust_linear,LM_robust_linear]=...
        testnl(v,V,u_linear,z_linear,s,[],d_linear,phi_linear,[],[],0,p,T,0.95);
    if robust == 0
        increase = rejectH0_linear;
    else
        increase = rejectH0_robust_linear;
    end
else
    if M>0
        increase = 1;
    else
        increase = 0;
    end
end

m = 0;
d = d_linear;

while increase==1
    m = m + 1;
    
    % starting values for gamma and c
    [gamma,c] = startval(v,V,s,m,gamma,c,T,p);
    gamma_initial = gamma;
    
    % construct the vector of parameters
    PSI = setpar(d,gamma,c);
      
    options = optimset('Display','off','GradObj','off','MaxFunEvals',1e10,...
        'MaxIter',6000,'TolFun',0.01,'DerivativeCheck','off',...
        'TolX',1e-8); %'LineSearchType','cubicpoly',
    
    PSI = fminunc(@(PSI) msecostnl(PSI,y,s,p,m,T),PSI,options);
       
    [d,gamma,c] = getpar(PSI,m);
    aux   = [gamma,c];
    aux   = sortrows(aux,2);
    gamma = aux(:,1);
    c     = aux(:,2);
    
    %v = fracfilter(y,d);
    v = fractint_filter_d(y,d,100);
    
    V = zeros(T-p,p);
    for i=1:p
        V(:,i) = v(p-i+1:T-i);
    end
    v = v(p+1:end);
    
    fX = zeros(T-p,m);
    for i=1:m
        fX(:,i)            = siglog(gamma(i)*(s-c(i)));
        V(:,i*p+1:(i+1)*p) = repmat(fX(:,i),1,p).*V(:,1:p);
    end
    theta = pinv(V'*V)*V'*v;
    phi   = reshape(theta,p,m+1);
    vhat  = V(:,1:p)*phi(:,1) + V(:,p+1:end)*vec(phi(:,2:end));
    u     = v - vhat;
    z     = invfilter(u,d,T-p);
    
    if flag_M==1
        [rejectH0,pvalue,LM,...
        rejectH0_robust,pvalue_robust,LM_robust]=...
        testnl(v,V,u,z,s,fX,d,phi,gamma,c,m,p,T,1-(1-0.95)/(2^m));
        if robust == 0
            increase = rejectH0;
        else
            increase = rejectH0_robust;
        end
        if m>3
            increase = 0;
        end
    else
        if m<M
            increase = 1;
        else
            increase = 0;
        end
    end
end
if m>0
    d_hat     = d;
    phi_hat   = phi;
    %theta_hat = theta;
    gamma_hat = gamma;
    c_hat     = c;
    M_hat     = m;
    sigma_hat = std(u);
    G_hat     = calcgrad(V,u,z,s,fX,d,phi,gamma,c,m,p,T);
    u_hat     = u;
else
    d_hat         = d_linear;
    phi_hat       = phi_linear;
    gamma_hat     = [];
    c_hat         = [];
    M_hat         = m;
    sigma_hat     = std(u_linear);
    G_hat         = calcgrad(V,u_linear,z_linear,[],[],d_linear,phi_linear,[],[],m,p,T);
    pvalue        = [];
    LM            = [];
    pvalue_robust = [];
    LM_robust     = [];
    u_hat         = u_linear;
end
