function L = msecostnl(PSI,y,s,p,M,T)

% Input variables:
% ---------------
% PSI:  parameter vector
% y:    dependent variable
% p:    AR order    

% Get parameters
[d,gamma,c] = getpar(PSI,M);

% construct filtered series
%v = fracfilter(y,d);
v = fractint_filter_d(y,d,100);

% construct lagged series
V = zeros(T-p,p*(M+1));
for i=1:p
    V(:,i) = v(p-i+1:T-i);
end
v = v(p+1:end);

fX = zeros(T-p,M);
for m=1:M
    fX(:,m)            = siglog(gamma(m)*(s-c(m)));
    V(:,m*p+1:(m+1)*p) = repmat(fX(:,m),1,p).*V(:,1:p);
end
theta = pinv(V'*V)*V'*v;
phi   = reshape(theta,p,M+1);
vhat   = V(:,1:p)*phi(:,1) + V(:,p+1:end)*vec(phi(:,2:end));
u     = v - vhat;

alert_gamma = sum(gamma<0);

if abs(d)<0.5 && alert_gamma == 0
    L = sum(u.^2)/T;
else
    L = 100000;
end
