function lambda = stfiaparch_weights(parameters,p,q,truncLag,G)
% Parse parameters
if q
    beta1 = parameters(2+p);
    beta2 = parameters(3+p);
else
    beta1 = 0;
    beta2 = 0;
end

if p
    phi = parameters(1);
    d = parameters(2);
else
    phi = 0;
    d = parameters(1);
end


% Recursive weight computation
lambda = zeros(truncLag,1);
deltaa = zeros(truncLag,1);
lambda(1) = phi - ((1-G)*beta1+G*beta2) + d;
deltaa(1) = d;
for i=2:truncLag
    deltaa(i) = (i-1-d)/i * deltaa(i-1);
    lambda(i) = ((1-G)*beta1+G*beta2)*lambda(i-1) + (deltaa(i) -phi *deltaa(i-1));
end