function ht=stfiaparch_core(data_aug,abs_data_aug,parameters,p,o,q,m,T,back_cast,LB,UB)
% Conditional variance computation for a STFIAPARCH(P,O,Q) process.
%
% USAGE:
%   [HT] = aparch_core(DATA_AUG,ABS_DATA_AUG,PARAMETERS,P,O,Q,M,T)
%
% INPUTS:
%   DATA_AUG      - Vector of mean zero residuals augmented with zeros
%   ABS_DATA_AUG  - Absolute value of augmented data
%   PARAMETERS    - 1+P+O+Q by 1 vector of parameters
%   P             - Positive, scalar integer representing the number of
%                   symmetric innovations
%   O             - Non-negative scalar integer representing the number
%                   of asymmetric innovations (0 for symmetric processes)
%   Q             - Non-negative, scalar integer representing the number
%                   of lags of conditional variance (0 for ARCH)
%   M             - Number of back casts needed
%   T             - Length of FDATA, including any appended back casts
%
% OUTPUTS:
%   HT            - Vector of conditonal varainces, T by 1
%



if nargin==8 && estimFlag
    [parameters,nu,lambda] = stfiaparch_itransform(parameters,p,q,errorType);
end

omega = parameters(1);
gamma = parameters(p+q+3);
delta = parameters(p+q+4);
deltainv=2/delta;
stfiaparchWeightParameters = parameters(2:2+p+q);
T = size(data,1);
archWeights = stfiaparch_weights(stfiaparchWeightParameters,p,q,truncLag);
tau = truncLag+1:truncLag+T;
ht = zeros(size(epsilon2));
for t = tau;
    ht(t) = omega + archWeights'.*(abs(epsilon2(t-1:-1:t-truncLag))-gamma.*epsilon2(t-1:-1:t-truncLag)).^(delta);
end
ht = ht(tau).^(deltainv);


