% Function to compute starting valus for a multiple-regime Smooth
% Transition Regression (STR). The algorithm is based on a grid search over
% the parameters gamma and c.

function [gammaf,cf]=startval(v,V,s,M,gamma,c,T,p)

% inputs:
% ------
% v:        dependent variable
% V:        regressors
% s:        transition variable
% M:        number of nonlinear terms (number of regimes - 1)
% gamma:    gamma values for the previous nonlinear terms
% c:        c values for the previous nonlinear terms
% p:        AR order
% T:        number of observations

bestcost = 999999999999999999999999;

% Maximum and minimum values for gamma
% ------------------------------------
maxgamma  = 50;
mingamma  = 10;
rategamma = 1;

% Maximum and minumum values for c
% --------------------------------
minc  = prctile(s,10);
maxc  = prctile(s,90);
ratec = (maxc-minc)/200;

gamma(M,1) = 0;
c(M,1) = 0;
for newgamma=mingamma:rategamma:maxgamma
    for newc=minc:ratec:maxc
        gamma(M,1) = newgamma;
        c(M,1)     = newc;
        fX = zeros(T-p,M);
        for m=1:M
            fX(:,m)            = siglog(gamma(m)*(s-c(m)));
            V(:,m*p+1:(m+1)*p) = repmat(fX(:,m),1,p).*V(:,1:p);
        end
        theta = pinv(V'*V)*V'*v;
        phi   = reshape(theta,p,M+1);
        vhat   = V(:,1:p)*phi(:,1) + V(:,p+1:end)*vec(phi(:,2:end));
        e      = v - vhat;
      	cost   = var(e);
       	if cost<=bestcost
            bestcost = cost;
            gammaf   = gamma;
            cf       = c;
        end
    end
end