function u = lstar(y,s,T,m,p)

gamma    = [];
c        = [];
d_linear = 0.4;

ybar = mean(y);
y = y - ybar;

% linear estimation
options = optimset('Display','off','GradObj','off','MaxFunEvals',1e10,...
        'MaxIter',6000,'TolFun',1e-8,'DerivativeCheck','off',...
        'TolX',1e-8); %'LineSearchType','cubicpoly',
d_linear= fminunc(@(d_linear) msecost(d_linear,y,p,T),d_linear,options);
     
% construct filtered series
%v = fracfilter(y,d_linear);
v = fractint_filter_d(y,d_linear,100);

% construct lagged series
V = zeros(T-p,p);
for i=1:p
    V(:,i) = v(p-i+1:T-i);
end
v = v(p+1:end);
s = s(p+1:end);
    
d = d_linear;
% starting values for gamma and c
    [gamma,c] = startval(v,V,s,m,gamma,c,T,p);
    %gamma_initial = gamma;
    
    % construct the vector of parameters
    PSI = setpar(d,gamma,c);
      
    options = optimset('Display','off','GradObj','off','MaxFunEvals',1e10,...
        'MaxIter',6000,'TolFun',0.01,'DerivativeCheck','off',...
        'TolX',1e-8); %'LineSearchType','cubicpoly',
    
    %PSI = fminunc(@(PSI) msecostnl(PSI,y,s,p,m,T),PSI,options);
    [PSI,~,~,~,~,hessian] = fminunc(@(PSI) msecostnl(PSI,y,s,p,m,T),PSI,options);
    
       
    [d,gamma,c] = getpar(PSI,m);
    aux   = [gamma,c];
    aux   = sortrows(aux,2);
    gamma = aux(:,1);
    c     = aux(:,2);
    
    %v = fracfilter(y,d);
    v = fractint_filter_d(y,d,100);
    
    V = zeros(T-p,p);
    for i=1:p
        V(:,i) = v(p-i+1:T-i);
    end
    v = v(p+1:end);
    
    fX = zeros(T-p,m);
    for i=1:m
        fX(:,i)            = siglog(gamma(i)*(s-c(i)));
        V(:,i*p+1:(i+1)*p) = repmat(fX(:,i),1,p).*V(:,1:p);
    end
    theta = pinv(V'*V)*V'*v;
    phi   = reshape(theta,p,m+1);
    vhat  = V(:,1:p)*phi(:,1) + V(:,p+1:end)*vec(phi(:,2:end));
    u     = v - vhat;
    s     = (u'*u)/(T-p-m);
    se   = sqrt(diag(s*pinv(V'*V)));
    z     = invfilter(u,d,T-p);
    

