function yhat =nlprev(y,s,d,phi,gamma,c,M,p,T,const)
   
% construct filtered series
v = fractint_filter_d(y,d,100);

% construct lagged series
V = zeros(T-p,p);
for i=1:p
    V(:,i) = v(p-i+1:T-i);
end
if const == 1
    V = [ones(T-p),V];
end       
s = s(p+1:end);

if M>0
    fX = zeros(T-p,M);
    for i=1:M
        fX(:,i)            = siglog(gamma(i)*(s-c(i)));
        if const==1
            V(:,i*(p+1)+1:(i+1)*(p+1)) = repmat(fX(:,i),1,p+1).*V(:,1:p+1);
            vhat  = V(:,1:p+1)*phi(:,1) + V(:,p+2:end)*vec(phi(:,2:end));
        else
            V(:,i*p+1:(i+1)*p) = repmat(fX(:,i),1,p).*V(:,1:p);
            vhat  = V(:,1:p)*phi(:,1) + V(:,p+1:end)*vec(phi(:,2:end));
        end
    end
    
else
    vhat  = V(:,1:p)*phi(:,1);
end

yhat = invfilter(vhat,d,T-p);

keyboard
